import { _decorator, Component, Font, Label, RichText } from "cc";
import I18Mgr from "./I18Mgr";
import { addEventListener, removeEventListener } from "./EventManager";

const { ccclass, property } = _decorator;

@ccclass('I18Font')
export class I18Font extends Component {

    @property
    _key:string = "";

    @property
    get key(){
        return this._key;
    }

    set key( v: string ){
        const self = this;
        if( self._key == v ) return;
        self._key = v;
    }

    _bLoadFont = false;

    protected onLoad(): void {
        const self = this;
        addEventListener( "I18BundleReady", self, self.refresh );
    }

    protected onEnable(){
        const self = this;
        if( !self._bLoadFont ){
            self.refresh();
        }
    }

    protected onDestroy(): void {
        const self = this;
        removeEventListener( self );
    }

    refresh(){
        const self = this;
        if( self._key == "" ) return;

        // let lb : Label | RichText = self.node.getComponent(Label);
        // if( lb == null ) lb = self.node.getComponent( RichText );
        const lb = self.node.getComponent( Label );
        if( lb == null ) return;
        if( lb.useSystemFont ) return;
        
        I18Mgr.getInstance().getRes( self._key, Font, ( err, font )=>{
            if( err ) return;
            if( !self.isValid ) return;
            lb.font = font;
            lb.updateRenderData( true );
        } );
    }
}