import { AssetManager, assetManager, error, JsonAsset, log } from "cc";

export default class TxtMgr {

    static url:string = "txt";
    static instance : TxtMgr = null;
    static getInstance(): TxtMgr{
        if( TxtMgr.instance == null ){
            TxtMgr.instance = new TxtMgr();
        }
        return TxtMgr.instance;
    }

    data: any = null;

    async setBundle( bundle: AssetManager.Bundle ){
        const self = this;
        return new Promise((resolve, reject)=>{
            bundle.load( TxtMgr.url, JsonAsset, ( err: Error, data: JsonAsset )=>{
                if( err ){
                    error( "TxtMgr setBundle error" );
                    error( err );
                    resolve( 0 );
                    return;
                }
                self.data = data.json;
                resolve( 1 );
            } );
        })
    }

    setData( data: JsonAsset ){
        this.data = data.json;
    }

    getTxt( key: string, ...params ) : string {
        const self = this;

        if( self.data == null ){
            let result = key;
            for( const str of params ){
                result += " " + str;
            }
            return result;
        }

        let txtData = null;
        if( key.indexOf("etxt") != 0 ){
            txtData = self.data;
        }else{
            txtData = self.data[ "zzz___editor_txt___" ];
        }

        if( txtData == null || txtData[key] == null ){
            let result = key;
            for( const str of params ){
                result += " " + str;
            }
            return result;
        }

        let result = txtData[key].replace( '\'', "\"" );
        for( let i=0; i<params.length; ++i ){
            result = result.replace( `{${i+1}}`, params[i].toString() );
        }
        return result;
    }

}

export const txt = function( key: string, ...params ){
    return TxtMgr.getInstance().getTxt( key, ...params );
}