// 状态接口
export interface IState
{
    // 进入状态
    Enter(param:any) : void;
    
    // 退出状态
    Leave() : void;

    Update(dt:number) : void;

    GetStateID() : number;

    // 触摸事件
    OnTouchEvent(code:object, param1?:any, param2?:any): void;
}
/*
*状态机
*/
export class State<T> implements IState
{
    protected m_nStateID : number = 0;
    protected m_Owner : T = null;  // 状态所有者
    public constructor(id:number,owner:T)
    {
        this.m_nStateID = id;
        this.m_Owner = owner;
    }
    /// 状态宿主
    get owner() : T { return this.m_Owner; }
    // 进入状态
    Enter(param:any) : void
    {
    }
    
    // 退出状态
    Leave() : void
    {
    }
    Update(dt:number) : void
    {
    }
    // 触摸事件
    OnTouchEvent(code:object, param1?:any, param2?:any): void
    {
        
    }
    GetStateID() : number
    {
        return this.m_nStateID;
    }
}

export class StateMachine<T>
{
    // 状态列表 不允许重复状态
    private m_dicState : Object = {};
    // 当前状态
    private m_curState : State<T> = null;
    public constructor()
    {
    }
    // 注册状态
    public RegisterState(s:State<T>):void
    {
        if(s==null)
        {
            return;
        }
        var state: State<T> = this.m_dicState[s.GetStateID()];
        if (state==null)
        {
            this.m_dicState[s.GetStateID()] = s;
        }
    }
    // 取消状态
    public UnRegisterState(nStateID:number) : void
    {
        var state: State<T> = this.m_dicState[nStateID];
        if (state!=null)
        {
            this.m_dicState[nStateID] = null;
        }
    }
    // 清空状态列表
    public UnRegisterAllState()
    {
        this.m_dicState = {};
    }
    public GetCurState():State<T>
    {
        return this.m_curState;
    }
    public GetCurStateID() : number
    {
        if( this.m_curState != null )
        {
            return this.m_curState.GetStateID();
        }
        return -1;
    }
    // 改变状态
    public ChangeState(nStateID:number, param:any)
    {
        if(this.GetCurStateID()==nStateID)
        {
            return;
        }
        
        var state: State<T> = this.m_dicState[nStateID];
        if (state!=null)
        {
            if(this.m_curState != null)
            {
                this.m_curState.Leave();
            }
            if (state != null)
            {
                this.m_curState = state;
                state.Enter(param);
            }
        }
        else
        {
            // 状态不支持
        }
    }
    public Update(dt:number)
    {
        if( this.m_curState != null )
        {
            this.m_curState.Update(dt);
        }
    }
}