const Constant = require("./Constant");

cc.Class({
    extends: cc.Component,

    ctor(){
        this.resize = false;
    },

    properties: {
        lb_wh:cc.Label,
        lb_wh1:cc.Label,
    },

    onLoad() {
        Constant.ScreenFit = this;
        this.canvas = this.node.getComponent(cc.Canvas);
        cc.view.setResizeCallback(() => {
            this.onResize()
        });
    },

    start() {
        this.onResize();
    },

    onResize() {
        var size = cc.winSize;
        if (size.width > size.height) {  //横屏
            Constant.ScreenFitView.ON_SCREEN_HORIZONTAL();
        }
        else { //竖屏
            Constant.ScreenFitView.ON_SCREEN_VERTICAL();
        }
    },


    fullscreen() {
    },


    update(dt) {
        this.lb_wh.string = 'width:' + cc.game.canvas.width + '   height:' + cc.game.canvas.height +'  '+cc.view._resizeWithBrowserSize;

        this.lb_wh1.string = 'w:'+window.screen.width+'  h:'+window.screen.height + '  offx:'+window.screenX+'   offy:'+window.screenY;
    },
});

module.exports = window.ScreenFitData = {
    designWidth: 1280,
    designHeight: 720,
    scale: 1,
    scaleX: 1,
    scaleY: 1,
};
