// Learn TypeScript:
//  - https://docs.cocos.com/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

const { ccclass, property } = cc._decorator;

@ccclass
export default class NewClass extends cc.Component {

    @property(sp.Skeleton)
    testSpine: sp.Skeleton = null;



    start() {
        // let testsp1 = cc.find('Canvas/spine').getComponent(sp.Skeleton);
        cc.resources.load("sk/renwu-hongyan_a", sp.SkeletonData, (bb: any, testsp2: sp.SkeletonData) => {
            if (!testsp2) {
                console.error('资源加载失败 LoadSkeleton')
            }
            console.log("--------------------------", testsp2);
            let spine = cc.find('Canvas/test').getComponent(sp.Skeleton);
            // this.copySkeletonData(spine, testsp1.skeletonData)
            this.copySkeletonData(spine, testsp2)

        });
    }

    copySkeletonData(spine: sp.Skeleton, data: sp.SkeletonData, is_set: boolean = true) {
        let date = new Date();
        // 记录当前播放的动画
        const animation = 'attack1'
        const spdata = data;
        let copy = new sp.SkeletonData();
        cc.js.mixin(copy, spdata);
        // @ts-ignore
        copy._uuid = spdata._uuid + "_" + date.getTime() + "_copy";
        let old = copy.name;
        let newName = copy.name + "_copy";
        copy.name = newName;
        copy.atlasText = copy.atlasText.replace(old, newName);
        // @ts-ignore
        copy.textureNames[0] = newName + ".png";
        if(jsb){ // 自己做下情况处理。找不到 bin 文件导致得
            copy._nativeUrl = data.nativeUrl;
        }
        // @ts-ignore
        copy.init && copy.init();
        if (is_set) {
            // spine.node.opacity = 0;
            spine.skeletonData = copy;
            // 继续播放的动画，不然会停止
            spine.setSkin('a');
            spine.setAnimation(0, animation, true);
        }
    
    }
    // update (dt) {}
}
