
import { _decorator, Component, Node, resources, sp, Prefab, instantiate, find } from 'cc';
import { Role } from './Role';
const { ccclass, property } = _decorator;

/**
 * Predefined variables
 * Name = NewComponent
 * DateTime = Tue May 24 2022 11:30:23 GMT+0800 (中国标准时间)
 * Author = Koei
 * FileBasename = NewComponent.ts
 * FileBasenameNoExtension = NewComponent
 * URL = db://assets/NewComponent.ts
 * ManualUrl = https://docs.cocos.com/creator/3.4/manual/zh/
 *
 */
 
@ccclass('NewComponent')
export class NewComponent extends Component {
    // [1]
    // dummy = '';

    // [2]
    @property(Prefab)
    testPrefab:Prefab = null
    // serializableDummy = 0;

    start () {
        resources.load("spineboy/spineboy", sp.SkeletonData, (err, spineAsset)=> {
            if(err) {
                return;
            }
            let item = instantiate(this.testPrefab);

            let comp = item.getComponent(Role);
            comp.ske.skeletonData = spineAsset!;
            find('Canvas').addChild(item);
            comp.stand();
        });
    }

    // update (deltaTime: number) {
    //     // [4]
    // }
}

/**
 * [1] Class member could be defined like this.
 * [2] Use `property` decorator if your want the member to be serializable.
 * [3] Your initialization goes here.
 * [4] Your update function goes here.
 *
 * Learn more about scripting: https://docs.cocos.com/creator/3.4/manual/zh/scripting/
 * Learn more about CCClass: https://docs.cocos.com/creator/3.4/manual/zh/scripting/decorator.html
 * Learn more about life-cycle callbacks: https://docs.cocos.com/creator/3.4/manual/zh/scripting/life-cycle-callbacks.html
 */
