// Learn TypeScript:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/typescript.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/reference/attributes.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/life-cycle-callbacks.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/life-cycle-callbacks.html

const { ccclass, property } = cc._decorator;

@ccclass
export default class NewClass extends cc.Component {

    @property(cc.Slider)
    test_music: cc.Slider = null;

    @property(cc.AudioClip)
    mp3_music:cc.AudioClip=null;
    // @property(cc.AudioClip)
    // mp3_music: {
    //     default: null,
    //     type: cc.AudioClip,  // use 'type:' to define Asset object directly
    // };
    _musicId: number = -1;
    _musicVolume: number;

    // LIFE-CYCLE CALLBACKS:

    // onLoad () {}

    start() {
        // cc.loader.loadRes('snd_bg', cc.AudioClip, (err, clip) => {
        //     // cc.audioEngine.play(clip);
        //     if (err) {
        //         cc.error(err);
        //     } else {

        //         this.playMusic(clip, true);
        //     }
        // });
        this.playMusic(this.mp3_music,true);
    }
    playMusic(clip: cc.AudioClip, loop?: boolean) {
        loop = typeof loop !== 'undefined' ? loop : true;
        if (this._musicId !== -1) {
            cc.audioEngine.stop(this._musicId);
        }
        this._musicId = cc.audioEngine.play(clip, loop, this._musicVolume);
        cc.log('start   _musicId:', this._musicId)
    }
    onCallButton(event, customEventData) {
        let num = event.progress.toFixed(2);
        cc.log("this._musicId:", this._musicId)
        cc.log("this._musicVolume:", this._musicVolume);
        cc.log("num:", num);
        this._musicVolume = num;
        if (this._musicId !== -1 && this._musicVolume) {
            cc.audioEngine.setVolume(this._musicId, this._musicVolume);
        }
    }
    // update (dt) {}
}
