// Learn TypeScript:
//  - https://docs.cocos.com/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

const {ccclass, property} = cc._decorator;

@ccclass
export default class NewClass extends cc.Component {

    @property(sp.Skeleton)
    sp: sp.Skeleton = null;

    @property
    text: string = 'hello';

    // LIFE-CYCLE CALLBACKS:

    onLoad () {
        cc.resources.load("tou1", cc.SpriteFrame, (err, spriteFrame: cc.SpriteFrame) => {
            if (err) return console.error(err);
            // this.changeDress(this.ren, "04liantiqun", spriteFrame);
            // this.changeDress(this.ren, "tou", null);
            this.changeDress(this.sp, "tou", spriteFrame);
        });

        this.schedule(()=>{
            this.sp.setAnimation(0,"zoulu1",false)
        },3,10)
    }

    start () {
      
    }



    //换装
    changeDress(target: sp.Skeleton = this.ren, slotName = "tou", spriteFrame) {
        //直接替换图片
        let skeletonData: sp.spine.SkeletonData = target.skeletonData.getRuntimeData();
        let skin = skeletonData.defaultSkin;
        // 找到骨骼的index
        let slotindex = skeletonData.findSlotIndex(slotName);
        // 找到需要换图的插槽
        let atta = skin.getAttachment(slotindex, slotName);
        // console.log("a", target);
        // console.log("skeletonData", skeletonData);
        // console.log("skin", skin);
        // console.log("slotindex", slotindex);
        // console.log("atta", atta);

        let attaType = null;
        if (atta instanceof sp.spine.RegionAttachment) {
            attaType = 1;
        } else if (atta instanceof sp.spine.MeshAttachment) {
            attaType = 2;
        }

        // 通过图片创建插槽的region
        let region = this.createAttachRegion(spriteFrame, attaType);


        if (attaType == 1) {
            if (region) {
                atta["setRegion"](region);
            }else{
                atta["region"].width = 0;
                atta["region"].height = 0;
            }
            atta["updateOffset"]();
        } else if (attaType == 2) {
            if (region) {
                atta["region"] = region;
            }else{}
            atta["updateUVs"]();
        }

        // skin.setAttachment(slotindex,"tou",atta);//这不需要也成
        //注：位置不对的时候texture可能需要设置TrimType类型为Auto=>None
    }


    //创建AttachRegion
    createAttachRegion(spriteFrame: cc.SpriteFrame, attaType: number) {
        let sprite_frame = spriteFrame;
        if (!sprite_frame) return null;

        let texture = sprite_frame.getTexture();
        let rect = sprite_frame.getRect();
        let isrotated = sprite_frame.isRotated();
        let offset = sprite_frame.getOffset();
        let original_size = sprite_frame.getOriginalSize();

        let skeletonTexture = new sp["SkeletonTexture"]();
        skeletonTexture.setRealTexture(texture);
        let region = null;
        if (attaType == 1) {
            region = new sp.spine.TextureAtlasRegion();
        } else if (attaType == 2) {
            region = new sp.spine.MeshAttachment("");
        }
        //单张图片可以不用创建page
        // let page = new sp.spine.TextureAtlasPage();
        // page.uWrap = sp.spine.TextureWrap.ClampToEdge;
        // page.vWrap = sp.spine.TextureWrap.ClampToEdge;
        // page.texture = skeletonTexture;
        // page.texture.setWraps(page.uWrap, page.vWrap);
        // page.width = rect.width;
        // page.height = rect.height;
        // region.page = page;
        region.rotate = isrotated;
        region.x = rect.x;
        region.y = rect.y;
        region.offsetX = offset.x;
        region.offsetY = offset.y;
        region.width = rect.width;
        region.height = rect.height;
        region.originalWidth = original_size.width;
        region.originalHeight = original_size.height;
        region.u = rect.x / texture.width;
        region.v = (rect.y) / texture.height;
        region.u2 = (rect.x + rect.width) / texture.width;
        region.v2 = (rect.y + rect.height) / texture.height;
        region.texture = skeletonTexture;
        return region;
    }


    // update (dt) {}
}
