import { _decorator, Component, EventTouch, instantiate, Mat4, Node, NodeEventType, ParticleSystem2D, Prefab, UITransform, Vec3 } from "cc";
const { ccclass, property } = _decorator;

@ccclass("Demo")
export class Demo extends Component {
    @property({ type: Prefab })
    public ps2dPrefab: Prefab;

    private _unlives: Node[] = [];
    private _alives: ParticleSystem2D[] = [];

    private _width: number = 0;
    private _height: number = 0;

    protected start() {
        this.node.on(NodeEventType.TOUCH_START, this.onTouchStart, this);

        var uiTf = this.getComponent(UITransform);
        this._width = uiTf.width;
        this._height = uiTf.height;
    }

    protected update(dt: number): void {
        for (let i = 0, len = this._alives.length; i < len; i++) {
            const ps2d = this._alives[i];
            if (ps2d.stopped) {
                this._alives.splice(i, 1);
                this._unlives.push(ps2d.node);
                ps2d.node.active = false;
                ps2d.node.parent.removeChild(ps2d.node);
                i--;
                len--;
            }
        }
    }

    private onTouchStart(ev: EventTouch) {
        var node: Node = this._unlives.pop();
        var created = false;
        if (!node) {
            created = true;
            node = instantiate(this.ps2dPrefab);
        }

        let v2UILocal = ev.getUILocation();
        let v3Temp = new Vec3(v2UILocal.x, v2UILocal.y, 0);
        v3Temp = UIWorldPositionToUILocalPosition(v3Temp, this.node);
        node.setPosition(v3Temp);
        node.active = true;

        const ps2d = node.getComponent(ParticleSystem2D);
        ps2d.autoRemoveOnFinish = false;
        ps2d.playOnLoad = false;
        // 项目从3.7.1升级为3.8.2, 报错：、
        // TypeError: Cannot read properties of undefined (reading 'resize')
        // at Simulator.reset (c:\Users\m1889\Desktop\NewProject\scripting\engine\cocos\particle-2d\particle-simulator-2d.ts:143:25)
        // at ParticleSystem2D.resetSystem (c:\Users\m1889\Desktop\NewProject\scripting\engine\cocos\particle-2d\particle-system-2d.ts:890:25)
        // at Demo.onTouchStart (c:\Users\m1889\Desktop\NewProject\assets\scripts\demo.ts:57:14)
        // at CallbacksInvoker.emit (c:\Users\m1889\Desktop\NewProject\scripting\engine\cocos\core\event\callbacks-invoker.ts:344:34)
        // at NodeEventProcessor.dispatchEvent (c:\Users\m1889\Desktop\NewProject\scripting\engine\cocos\scene-graph\node-event-processor.ts:285:33)
        // at Node.dispatchEvent (c:\Users\m1889\Desktop\NewProject\scripting\engine\cocos\scene-graph\node.ts:1227:30)
        // at NodeEventProcessor._handleTouchStart (c:\Users\m1889\Desktop\NewProject\scripting\engine\cocos\scene-graph\node-event-processor.ts:610:18)
        // at NodeEventProcessor._handleEventTouch (c:\Users\m1889\Desktop\NewProject\scripting\engine\cocos\scene-graph\node-event-processor.ts:586:25)
        // at PointerEventDispatcher.dispatchEventTouch (c:\Users\m1889\Desktop\NewProject\scripting\engine\cocos\2d\event\pointer-event-dispatcher.ts:130:47)
        // at PointerEventDispatcher.dispatchEvent (http://localhost:7457/scripting/engine/bin/.cache/dev/preview/bundled/index.js:98354:25) {stack: 'TypeError: Cannot read properties of undefine….cache/dev/preview/bundled/index.js:98354:25)', message: "Cannot read properties of undefined (reading 'resize')"}

        // 3.8.2 开启下面的代码正常
        // if (created) {
        //     (ps2d as any)._flushAssembler();
        // }
        ps2d.resetSystem();

        this.node.addChild(node);
        this._alives.push(ps2d);
    }

}


function UIWorldPositionToUILocalPosition(v3UIWorld: Vec3, parent: Node): Vec3 {
    parent.updateWorldTransform();

    var wmat = parent.getWorldMatrix();
    var lmat = new Mat4();
    Mat4.invert(lmat, wmat);

    var v3Local = new Vec3();
    Vec3.transformMat4(v3Local, v3UIWorld, lmat);

    return v3Local;
}