import { _decorator, Component, Node } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('CustomButton')
export class CustomButton extends Component {

    private _onClick: Function;
    public isEnabled: boolean = true;
    onEnable() {
        // 注册按钮事件
        this.node.on(Node.EventType.TOUCH_START, this.onTouchStart, this);
        this.node.on(Node.EventType.TOUCH_END, this.onTouchEnd, this);
        this.node.on(Node.EventType.TOUCH_CANCEL, this.onTouchCancel, this);
    }

    onDisable() {
        // 移除事件监听
        this.node.off(Node.EventType.TOUCH_START, this.onTouchStart, this);
        this.node.off(Node.EventType.TOUCH_END, this.onTouchEnd, this);
        this.node.off(Node.EventType.TOUCH_CANCEL, this.onTouchCancel, this);
    }
    public setCallbacks(onClick: Function) {
        this._onClick = onClick;
    }
    onTouchStart() {
        console.log('onTouchStart',this.node.name);
        if(!this.isEnabled) return;
    }

    onTouchEnd() {
        console.log('onTouchEnd',this.node.name);
        if(!this.isEnabled) return;
        this._onClick && this._onClick();
    }

    onTouchCancel() {
        console.log('onTouchCancel',this.node.name);
        if(!this.isEnabled) return;
    }
}


