import { _decorator, Component, EventTouch, Node, Animation, view } from 'cc';
import { CustomButton } from './CustomButton';
const { ccclass, property } = _decorator;

@ccclass('Test')
export class Test extends Component {
    @property(CustomButton)
    button1: CustomButton = null;
    @property(CustomButton)
    button2: CustomButton = null;
    @property(CustomButton)
    button3: CustomButton = null;

    @property(Node)
    uiRoot: Node = null;
    @property(Node)
    efClick: Node = null;

    private zeroX: number = 0;
    private zeroY: number = 0;
    protected onEnable(): void {
        this.onUserInterface(Node.EventType.TOUCH_END, this.onClickEvent.bind(this), this, true); // 最后一个参数true代表监听捕获阶段的事件
        this.autoDesignView()
    }

    start() {
        this.button1.setCallbacks(this.onClick1.bind(this));
        this.button2.setCallbacks(this.onClick2.bind(this));
        this.button3.setCallbacks(this.onClick3.bind(this));
        // this.button2.setCallbacks(() => {
        //         console.log('onClick2');
        // });
        // this.button3.setCallbacks(() => {
        //     console.log('onClick3');
        // });
    }

    update(deltaTime: number) {

    }
    onClick1() {
        console.log('onClick1');
        this.button1.isEnabled = false;
        this.button1.node.active = false;
        this.button2.node.active = true;

        setTimeout(() => {
            this.button2.isEnabled = true;
        }, 2000);
    }
    onClick2() {
        console.log('onClick2');
        this.button2.isEnabled = false;

        setTimeout(() => {
            this.button2.node.active = false;

            this.button1.node.active = true;
            this.button1.isEnabled = false;
        }, 1000);
    }
    onClick3() {
        console.log('onClick3');
        this.button1.isEnabled = true;

    }

    public onUserInterface(...args: Parameters<Node['on']>) {
        Node.prototype.on.apply(this.uiRoot, args);
    }
    private onClickEvent(event: EventTouch) {
        if (this.efClick) {
            this.efClick.setPosition(this.zeroX + event.getUILocation().x, this.zeroY + event.getUILocation().y)
            this.efClick.active = true
            this.efClick.getComponent(Animation).play("click")
            // this.efClick.play("click")
        }
    }
    private autoDesignView() {
        let realScreen = view.getVisibleSize()
        this.zeroX = -realScreen.width / 2;
        this.zeroY = -realScreen.height / 2;
    }

}


