// Learn TypeScript:
//  - https://docs.cocos.com/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

const { ccclass, property } = cc._decorator;

@ccclass
export default class helloworld extends cc.Component {

    public onLoad(): void {
        let gameName: string = 'demo';
        this.$getGameBundle(gameName);
    }

    private $getGameBundle(gameName: string): void {
        cc.assetManager.loadBundle(gameName, (err: Error, bundle: cc.AssetManager.Bundle) => {
            this.$enterGameScene(bundle, gameName);
        });
    }

    private $enterGameScene(bundle: cc.AssetManager.Bundle, gameName: string) {
        bundle.loadScene(gameName, function (err, scene: cc.SceneAsset) {
            cc.director.runScene(scene);
        });
    }

}
