/*
 * @Author: error: error: git config user.name & please set dead value or install git && error: git config user.email & please set dead value or install git & please set dead value or install git
 * @Date: 2023-04-25 23:55:02
 * @LastEditors: error: error: git config user.name & please set dead value or install git && error: git config user.email & please set dead value or install git & please set dead value or install git
 * @LastEditTime: 2023-04-26 20:29:11
 * @FilePath: /Fling_Fun/assets/Script/Action/Effect.ts
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import { _decorator, Camera, Color, Component, instantiate, Node, ParticleSystem2D, Prefab, Size, Sprite, SpriteFrame, tween, Tween, UITransform, v3, Vec3 } from 'cc';
import EventManager from '../3rd/EventManager';
const { ccclass, property } = _decorator;

@ccclass('Effect')
export class Effect extends Component {

    @property(Camera)
    camera:Camera ; 

    @property(Camera)
    camera2:Camera ; 

    @property(Prefab)
    ball1: Prefab;
    
    @property(Prefab)
    ball2: Prefab;

    @property(SpriteFrame)
    spriteFrame: SpriteFrame;

    @property(Node)
    userNode: Node;

    @property(ParticleSystem2D)
    particleSystem2D: ParticleSystem2D;

    @property(Prefab)
    endParticleSystem2D: Prefab;

    start() {
        EventManager.Instance.on("createScaleEffect",this.createScaleEffect,this);
        EventManager.Instance.on("setBallTexture",this.setBallTexture,this);
        EventManager.Instance.on("createVibration",this.createVibration,this);
        EventManager.Instance.on("createEndEffect",this.createEndEffect,this);
    }

    protected onDestroy(): void {
        EventManager.Instance.off("createScaleEffect",this.createScaleEffect,this);
        EventManager.Instance.off("setBallTexture",this.setBallTexture,this);
        EventManager.Instance.off("createVibration",this.createVibration,this);
        EventManager.Instance.off("createEndEffect",this.createEndEffect,this);
    }

    setBallTexture(ball:Node , size:Size){
        ball.getComponent(Sprite).spriteFrame = this.spriteFrame;
        ball.getComponent(UITransform).setContentSize(size);
    }
     
    createScaleEffect( parent, duration: number, s: number,size:Size , isAddParent =true ) {

        let ball = instantiate(this.ball2);
        if(isAddParent){
            ball.parent = parent;
        }else{
            this.node.addChild(ball);
            ball.position = parent;
        }
        
        
        ball.getComponent(UITransform).setContentSize(size);

        let tempColor:Color = new Color(255,255,255, 255);
        Tween.stopAll();

        let sprite : Sprite = ball.getComponent(Sprite) ;

        tween(ball).to(duration, {scale: new Vec3(s, s, s)}).start();
      
        // 创建一个tween对象，并指定目标节点
        const opacityTween = tween()
        .target(sprite)
        .delay(duration/2)
        // 在1秒内将透明度变为0
        .to(duration/2, { opacity: 0 },{
            onUpdate(target:object,tar:number){
                tempColor.set(255,255,255, 255-tar*255);
                sprite.color = tempColor;
            }
        });

        // 动画结束后输出信息
        const finishCallback = () => {
            ball.removeFromParent();
        };

        // 添加一个回调函数，在动画完成时执行
        opacityTween.call(finishCallback);

        // 开始执行动画
        opacityTween.start();
    }

    /***
     * 
     * 震动屏幕
     * 
     */
    createVibration(){
        Tween.stopAllByTarget(this.camera.node);
        Tween.stopAllByTarget(this.camera2.node);

        var node = this.camera.node;
        this.vibration(node);


        var node2 = this.camera2.node;
        this.vibration(node2);
    }

    vibration(node: Node){
        // 创建震屏效果的tween对象
        const shakeTween = tween(node)
        // 在0.05秒内向左移动5个单位长度(x轴负方向)
        .to(0.05, { position: v3(node.position.x - 5, node.position.y, node.position.z) })
        // 在0.05秒内向右移动10个单位长度(x轴正方向)
        .to(0.05, { position: v3(node.position.x + 10, node.position.y, node.position.z) })
        // 在0.05秒内向左移动10个单位长度(x轴负方向)
        .to(0.05, { position: v3(node.position.x - 10, node.position.y, node.position.z) })
        // 在0.05秒内向右移动10个单位长度(x轴正方向)
        .to(0.05, { position: v3(node.position.x + 10, node.position.y, node.position.z) })
        // 在0.05秒内向左移动5个单位长度(x轴负方向)
        .to(0.05, { position: v3(node.position.x - 5, node.position.y, node.position.z) });

        // 开始执行震屏效果
        shakeTween.start();

    }

    createEndEffect(node:Node){

        let endParticleSystem2D = instantiate(this.endParticleSystem2D);

        endParticleSystem2D.parent = node;
        node.getComponent(Sprite).color = new Color(255,255,255,0);

        //this.scheduleOnce(() => { endParticleSystem2D.removeFromParent() },2.0);
    }

    update(dt:number ){
        this.particleSystem2D.node.position = this.userNode.getPosition();
    }
   
}



