

import { _decorator, Component, math, misc, Node, v2, v3, Vec2, Vec3 } from 'cc';
import { MathUtil } from '../Utils/MathUtil';
const { ccclass, property } = _decorator;

@ccclass('RotateAroundObj')
export class RotateAroundObj extends Component {
    @property({type: Node})
    public target: Node = null; // 旋转目标物体

    @property
    public radius: number = 100; // 半径

    @property
    public rotateSpeed: number = 150; // 旋转速度

    public angle: number = 0;


    public proPoint :Vec3 = v3();

    public cPoint :Vec3 = v3();
    public disAngle : number = 0;
    start() {
        this.node.getPosition(this.proPoint);
        this.node.getPosition(this.cPoint);
    }

    tempV3 = new Vec3();
    update(dt: number) {

        this.angle += this.rotateSpeed * dt;
        const x = this.target.position.x + this.radius * Math.cos(misc.degreesToRadians(this.angle));
        const y = this.target.position.y + this.radius * Math.sin(misc.degreesToRadians(this.angle));
        this.tempV3.set(x,y);
        this.node.setPosition(this.tempV3);

        this.node.getPosition(this.cPoint);
        //this.disAngle =  Vec3.angle(this.proPoint,this.cPoint);
        this.disAngle = MathUtil.getAngle( this.cPoint,this.proPoint);;
        this.node.getPosition(this.proPoint);
    }
}

