/*
 * @Author: error: error: git config user.name & please set dead value or install git && error: git config user.email & please set dead value or install git & please set dead value or install git
 * @Date: 2023-04-17 22:02:29
 * @LastEditors: error: error: git config user.name & please set dead value or install git && error: git config user.email & please set dead value or install git & please set dead value or install git
 * @LastEditTime: 2023-04-26 20:28:46
 * @FilePath: /RunMan/assets/Scripts/MyCollision.ts
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import { _decorator, CircleCollider2D, Collider2D, Component, Contact2DType, HingeJoint2D, IPhysics2DContact, Node, RigidBody2D, Size, tween, UITransform, v2, v3, Vec2, Vec3, view } from 'cc';
import { RotateAroundObj } from '../Action/RotateAroundObj';
import { MathUtil } from '../Utils/MathUtil';
import { Ball } from './Ball';
import EventManager from '../3rd/EventManager';

const { ccclass, property } = _decorator;

@ccclass('MyCollision')
export class MyCollision extends Component {

    isCon = true; //是否可以碰撞

    public isEnd = false;

    protected onLoad(): void {

        MathUtil.indexVec.set(this.node.getPosition().x);
    }

    start() {
        // 注册单个碰撞体的回调函数
        let collider = this.getComponent(Collider2D);
        if (collider) {
            collider.on(Contact2DType.BEGIN_CONTACT, this.onBeginContact, this);
            // collider.on(Contact2DType.END_CONTACT, this.onEndContact, this);
            // collider.on(Contact2DType.PRE_SOLVE, this.onPreSolve, this);
            // collider.on(Contact2DType.POST_SOLVE, this.onPostSolve, this);
        }
        
    }

    onDestroy() {
        let collider = this.getComponent(Collider2D);
        collider?.off(Contact2DType.BEGIN_CONTACT, this.onBeginContact, this);
        // collider?.off(Contact2DType.END_CONTACT, this.onEndContact, this);
        // collider?.off(Contact2DType.PRE_SOLVE, this.onPreSolve, this);
        // collider?.off(Contact2DType.POST_SOLVE, this.onPostSolve, this);
    }

    onBeginContact (selfCollider: Collider2D, otherCollider: Collider2D, contact: IPhysics2DContact | null) {
        if(!this.isCon) return ; 
        this.isCon = false;
        
        // 只在两个碰撞体开始接触时被调用一次
        console.log('onBeginContact');
        const selfPoint = selfCollider.node.getPosition();
        const center = otherCollider.node.getPosition() ;
        const sw = otherCollider.getComponent(CircleCollider2D).radius;
       // 为球形节点添加动作
       
       selfCollider.body.gravityScale = 0;
       //const angle = Math.atan2( selfPoint.y - center.y , selfPoint.x - center.x) * 180 / Math.PI;
       const angle = MathUtil.getAngle(selfPoint,center);
       let rotateAroundObj:RotateAroundObj = selfCollider.node.addComponent(RotateAroundObj) as RotateAroundObj;
       rotateAroundObj.target = otherCollider.node;
       rotateAroundObj.angle = angle;
       rotateAroundObj.radius = sw + selfCollider.getComponent(UITransform).width/2;
       rotateAroundObj.rotateSpeed = otherCollider.node.getComponent(Ball).speed;
       
        
       const data = {
            duration: 0.5,
            targetPos:center
       }
       EventManager.Instance.emit("setBallTexture",otherCollider.node,new Size(sw*2,sw*2));
       EventManager.Instance.emit("createScaleEffect",otherCollider.node,0.5,1.5,new Size(sw*2,sw*2));
       EventManager.Instance.emit("startFollow",data);
       
    }

    onEndContact (selfCollider: Collider2D, otherCollider: Collider2D, contact: IPhysics2DContact | null) {
        // 只在两个碰撞体结束接触时被调用一次
        //console.log('onEndContact');
        
    }
    onPreSolve (selfCollider: Collider2D, otherCollider: Collider2D, contact: IPhysics2DContact | null) {
        // 每次将要处理碰撞体接触逻辑时被调用
        //console.log('onPreSolve');
    }
    onPostSolve (selfCollider: Collider2D, otherCollider: Collider2D, contact: IPhysics2DContact | null) {
        // 每次处理完碰撞体接触逻辑时被调用
        //console.log('onPostSolve');
    }

    update(deltaTime: number) {
        if(this.isEnd)return ;
        var visibleSize = view.getVisibleSize();
        if(this.node.getPosition().y <= - (visibleSize.y/2)){
            this.isEnd = true;
            EventManager.Instance.emit("createScaleEffect",this.node.getPosition(),0.5,15,new Size(50,50),false);
            EventManager.Instance.emit("createVibration");
            EventManager.Instance.emit("createEndEffect",this.node);
        }
        
    }
}


