import {
  _decorator,
  AssetManager,
  assetManager,
  Component,
  Node,
  TiledLayer,
  TiledMap,
  TiledMapAsset,
} from "cc";
const { ccclass, property } = _decorator;

@ccclass("NewComponent")
export class NewComponent extends Component {
  @property({ type: Node })
  A: Node = null;
  @property({ type: Node })
  B: Node = null;
  start() {
    this.renderMap();
  }

  async renderMap() {
    assetManager.loadBundle("bundle", (err, bundle: AssetManager.Bundle) => {
      bundle.load("word/word-01", TiledMapAsset, async (err, tmxAsset) => {
        const mapX = 0 * 640;
        const mapY = 0 * 640;
        this.A.setPosition(mapX, mapY);

        const tileMap = this.A.getComponent(TiledMap);
        tileMap.tmxAsset = tmxAsset;

        this.A.parent = this.node;
      });
    });
    setTimeout(async () => {
      assetManager.loadBundle("bundle", (err, bundle: AssetManager.Bundle) => {
        bundle.load("word/word-01", TiledMapAsset, async (err, tmxAsset) => {
          const mapX = 1 * 640;
          const mapY = 0 * 640;
          this.B.setPosition(mapX, mapY);

          const tileMap = this.B.getComponent(TiledMap);
          tileMap.tmxAsset = tmxAsset;

          this.B.parent = this.node;
        });
      });
    }, 10000);
  }

  update(deltaTime: number) {}
}
