
import { _decorator, Component, Node, macro, EventTouch, SpriteFrame, UITransform, Vec3, Sprite, Color, Layers, view, Toggle } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('Main')
export class Main extends Component {

    @property(SpriteFrame)
    private testSpriteFrame: SpriteFrame = null;

    @property(Toggle)
    private testToggle: Toggle = null;

    private testNodeMap: Map<number, Node> = new Map();

    protected onLoad() {
        this.testToggle.isChecked = macro.ENABLE_MULTI_TOUCH;
        this.node.on(Node.EventType.TOUCH_START, this.onTouchEvent, this);
        this.node.on(Node.EventType.TOUCH_MOVE, this.onTouchEvent, this);
        this.node.on(Node.EventType.TOUCH_CANCEL, this.onTouchEnd, this);
        this.node.on(Node.EventType.TOUCH_END, this.onTouchEnd, this);
    }

    private switchBtn(toggle: Toggle) {
        macro.ENABLE_MULTI_TOUCH = toggle.isChecked;
    }

    private clearDisplayNode() {
        this.testNodeMap.forEach((node) => node.destroy());
        this.testNodeMap.clear();
    }

    private onTouchEvent(event: EventTouch) {
        event.getTouches().forEach((touch) => {
            if (this.testNodeMap.has(touch.getID())) {
                const uiLoc = touch.getUILocation();
                this.testNodeMap.get(touch.getID()).setPosition(new Vec3(uiLoc.x - view.getVisibleSize().x / 2, uiLoc.y - view.getVisibleSize().y / 2, 0));
            } else {
                const node = new Node();
                node.layer = Layers.Enum.UI_2D;
                node.setScale(new Vec3(5, 5, 5));
                node.addComponent(UITransform);
                const uiLoc = touch.getUILocation();
                node.setPosition(new Vec3(uiLoc.x - view.getVisibleSize().x / 2, uiLoc.y - view.getVisibleSize().y / 2, 0));
                const sprite = node.addComponent(Sprite);
                sprite.spriteFrame = this.testSpriteFrame;
                sprite.color = new Color(Math.random() * 255, Math.random() * 255, Math.random() * 255, 100);
                node.parent = this.node;
                this.testNodeMap.set(touch.getID(), node);
            }
        });
    }

    private onTouchEnd(event: EventTouch) {
        event.getTouches().forEach((touch) => {
            const node = this.testNodeMap.get(touch.getID());
            this.testNodeMap.delete(touch.getID());
            if (node && node.isValid) {
                node.destroy();
            }
        });
    }
}
