// Learn TypeScript:
//  - https://docs.cocos.com/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

const {ccclass, property} = cc._decorator;

@ccclass
export default class CreateFace extends cc.Component {

    @property
    public rotateByX: boolean = false;
    @property
    public rotateByY: boolean = false;

    private _mesh: cc.Mesh;
    private _gfx;
    private _vfmtPosColor;

    start () {
        this._mesh = new cc.Mesh();
        this.getComponent(cc.MeshRenderer).mesh = this._mesh;
        this._gfx = cc.gfx;
        this._vfmtPosColor = new this._gfx.VertexFormat([
            { name: this._gfx.ATTR_POSITION, type: this._gfx.ATTR_TYPE_FLOAT32, num: 3 },
            { name: this._gfx.ATTR_UV0, type: this._gfx.ATTR_TYPE_FLOAT32, num: 2 },
            { name: this._gfx.ATTR_COLOR, type: this._gfx.ATTR_TYPE_UINT8, num: 4, normalize: true },
        ]);

        let vertices = [cc.v3(0, 0, 0), cc.v3(0, 1, 0), cc.v3(1, 0, 0), cc.v3(1, 1, 0)];
        let colors = [cc.Color.WHITE, cc.Color.WHITE, cc.Color.WHITE, cc.Color.WHITE];
        let uvs = [cc.v2(0, 0), cc.v2(0, 1), cc.v2(1, 0), cc.v2(1, 1)];
        let indrces = [0, 2, 1, 1, 2, 3, 0, 1, 2, 1, 3, 2];
        this._mesh.init(this._vfmtPosColor, 10, true);
        this._mesh.setVertices(this._gfx.ATTR_POSITION, vertices);
        this._mesh.setVertices(this._gfx.ATTR_COLOR, colors);
        this._mesh.setVertices(this._gfx.ATTR_UV0, uvs);
        this._mesh.setIndices(indrces);

    }

    update (dt) {
        if(this.rotateByX){
            this.node.eulerAngles = this.node.eulerAngles.add(cc.v3(90 * dt, 0, 0))
        }
        else if(this.rotateByY){
            this.node.eulerAngles = this.node.eulerAngles.add(cc.v3(0, 90 * dt, 0))
        }
    }
}
