
import { _decorator, Component, Node, Vec3 } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('SkeMove')
export class SkeMove extends Component {

    private frameCount: number = 0;
    private speed: number = 3;
    private baseScale: number = .2;

    update() {
        this.frameCount += 1;
        if (this.frameCount > 400) {
            this.frameCount = 0;
        } else {
            let pos: Vec3 = this.node.position.clone();
            if (this.frameCount >= 0 && this.frameCount < 100) {
                pos = pos.add3f(this.speed, 0, 0);
                this.node.setScale(this.baseScale, this.baseScale, this.baseScale);
            } else if (this.frameCount >= 100 && this.frameCount < 200) {
                pos = pos.add3f(0, -this.speed, 0);
            } else if (this.frameCount >= 200 && this.frameCount < 300) {
                pos = pos.add3f(-this.speed, 0, 0);
                this.node.setScale(-this.baseScale, this.baseScale, this.baseScale);
            } else if (this.frameCount >= 300 && this.frameCount < 400) {
                pos = pos.add3f(0, this.speed, 0);
            }
            this.node.setPosition(pos);
        }
    }
}