const { ccclass, property } = cc._decorator;

@ccclass
export default class SimpleRainbowLabel extends cc.Component {

    @property({
        type: cc.Float,
        tooltip: "颜色变化速度",
        min: 0,
        max: 10
    })
    speed: number = 1.0;

    private _material: cc.Material = null;
    private time: number = 0;

    onLoad() {
        this.applyRainbowEffect();
    }

    applyRainbowEffect() {
        const label = this.getComponent(cc.Label);
        if (!label) return;

        this._material = label.getMaterial(0);
        label['_material'] = this._material;
        label['_renderData'].material = this._material;
    }

    update(dt) {
        this.time += dt;

        // 手动更新颜色
        const label = this.getComponent(cc.Label);
        if (label && label.node) {
            // 基于时间计算彩虹颜色
            const hue = (this.time * this.speed) % 1;
            const color = this.hsvToRgb(hue, 1, 1);
            label.node.color = new cc.Color(
                Math.floor(color.r * 255),
                Math.floor(color.g * 255),
                Math.floor(color.b * 255)
            );
        }
    }

    // HSV转RGB函数
    hsvToRgb(h, s, v) {
        let r, g, b;
        let i = Math.floor(h * 6);
        let f = h * 6 - i;
        let p = v * (1 - s);
        let q = v * (1 - f * s);
        let t = v * (1 - (1 - f) * s);

        switch (i % 6) {
            case 0: r = v; g = t; b = p; break;
            case 1: r = q; g = v; b = p; break;
            case 2: r = p; g = v; b = t; break;
            case 3: r = p; g = q; b = v; break;
            case 4: r = t; g = p; b = v; break;
            case 5: r = v; g = p; b = q; break;
        }

        return { r, g, b };
    }
}