"use strict";
cc._RF.push(module, '2049elwzC5OGJr+Bp/As9Qs', 'rainbow');
// rainbow.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var SimpleRainbowLabel = /** @class */ (function (_super) {
    __extends(SimpleRainbowLabel, _super);
    function SimpleRainbowLabel() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.speed = 1.0;
        _this._material = null;
        _this.time = 0;
        return _this;
    }
    SimpleRainbowLabel.prototype.onLoad = function () {
        this.applyRainbowEffect();
    };
    SimpleRainbowLabel.prototype.applyRainbowEffect = function () {
        var label = this.getComponent(cc.Label);
        if (!label)
            return;
        this._material = label.getMaterial(0);
        label['_material'] = this._material;
        label['_renderData'].material = this._material;
    };
    SimpleRainbowLabel.prototype.update = function (dt) {
        this.time += dt;
        // 手动更新颜色
        var label = this.getComponent(cc.Label);
        if (label && label.node) {
            // 基于时间计算彩虹颜色
            var hue = (this.time * this.speed) % 1;
            var color = this.hsvToRgb(hue, 1, 1);
            label.node.color = new cc.Color(Math.floor(color.r * 255), Math.floor(color.g * 255), Math.floor(color.b * 255));
        }
    };
    // HSV转RGB函数
    SimpleRainbowLabel.prototype.hsvToRgb = function (h, s, v) {
        var r, g, b;
        var i = Math.floor(h * 6);
        var f = h * 6 - i;
        var p = v * (1 - s);
        var q = v * (1 - f * s);
        var t = v * (1 - (1 - f) * s);
        switch (i % 6) {
            case 0:
                r = v;
                g = t;
                b = p;
                break;
            case 1:
                r = q;
                g = v;
                b = p;
                break;
            case 2:
                r = p;
                g = v;
                b = t;
                break;
            case 3:
                r = p;
                g = q;
                b = v;
                break;
            case 4:
                r = t;
                g = p;
                b = v;
                break;
            case 5:
                r = v;
                g = p;
                b = q;
                break;
        }
        return { r: r, g: g, b: b };
    };
    __decorate([
        property({
            type: cc.Float,
            tooltip: "颜色变化速度",
            min: 0,
            max: 10
        })
    ], SimpleRainbowLabel.prototype, "speed", void 0);
    SimpleRainbowLabel = __decorate([
        ccclass
    ], SimpleRainbowLabel);
    return SimpleRainbowLabel;
}(cc.Component));
exports.default = SimpleRainbowLabel;

cc._RF.pop();