import { _decorator,Prefab, Component, instantiate, Node, resources, v3, game, director, MeshRenderer, url } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('FruitPoolManager')
export class FruitPoolManager {

    private _dictPool: any = {}

    private _dictPrefab: any = {}

    static _instance: FruitPoolManager;
    static get instance() {
        if (this._instance) {
            return this._instance;
        }
        this._instance = new FruitPoolManager();
        return this._instance;
    }

  
    public static loadRes(url: string, type: any, cb: Function) {
        resources.load(url, (err: any, res: any) => {
            if (err) {
                cb(err, res);
                return;
            }
            cb(null, res);
        })
    }

    public isPool(name: string) {
        if (this._dictPool.hasOwnProperty(name) && this._dictPool[name] ) {
            return true
        }
        return false
    }

    public getNodePool(name: string, p: Node) {
        let node: Node = null!;
        if (this._dictPool.hasOwnProperty(name) && this._dictPool[name].length > 0) {
            // 已有对应的对象池
            let pool = this._dictPool[name];
            node = pool.shift();
            // this._currPool[name].push(node);
            if (node && node.isValid){

                console.log("node.isValid", node.isValid)
            } 

        }
        else {
            // 没有对应对象池，创建他！
            let prefab = this._dictPrefab[name]
            node = instantiate(prefab)
        }
        node.parent = p;
        node.active = true;
        return node;
    }

    public putNode(node: Node,url) {
        if (!node) {
            return;
        }
        let name = url//node.name;
        if ( !this._dictPool.hasOwnProperty(name)) {
            this._dictPool[name] = [];
        }

        node.active = false;        
        node.parent = null
        node.scale = v3(1, 1, 1)
        this._dictPool[name].push(node);
    }


    public loadPrefab( url ) {

        if( this._dictPool[url] && this._dictPool[url].length > 0 ){
            return
        }
        FruitPoolManager.loadRes( url, Prefab, (err: any, pf: Prefab) => {
            if (err) {
                console.error(err);
                return;
            }
            // 2. 实例化一个临时节点，获取 MeshRenderer 并锁定资源
            let tempNode = instantiate(pf)
            const meshes = tempNode.getComponentsInChildren(MeshRenderer);
            meshes.forEach(mr => this.add_MeshRenderer(mr));
            this._dictPrefab[url] = tempNode
        })
       
    }

     add_MeshRenderer(mesh: MeshRenderer) {
            // 1. 清除 Mesh 数据
            if (mesh.mesh) {
                mesh.mesh.addRef()
            }
            mesh.material.addRef()
        }

    public prePool(prefab: Prefab, nodeNum: number,url:string) {
        this._dictPool[url] = []
        // this._currPool[url] = []
        for (let i = 0; i < nodeNum; i++) {
            const node = instantiate(prefab);
            this.putNode(node,url)
        }
    }


}


