/*
 * @Author: 林武
 * @Date: 2022-06-01 10:23:34
 * @LastEditors: 林武
 * @LastEditTime: 2022-06-07 10:09:35
 * @FilePath: \QuadTree\assets\Script\item.ts
 * @Description: 
 * 
 * Copyright (c) 2022 by 林武/长沙游品, All Rights Reserved. 
 */

const { ccclass, property } = cc._decorator;

@ccclass
export default class item extends cc.Component {

    /** 是否配置 */
    public isCollision: boolean = false;

    /** X轴的移动速度 */
    private speedX = 1;

    /** Y轴的移动速度 */
    private speedY = 1;

    // onLoad () {}

    /** 生命周期：节点开始 */
    start() {
        this.speedX *= Math.random() > 0.5 ? -1 : 1;
        this.speedY *= Math.random() > 0.5 ? -1 : 1;
        this.node.x = Math.random() * cc.Canvas.instance.node.width;
        this.node.y = Math.random() * cc.Canvas.instance.node.height;
    }

    /** 生命周期：帧更新 */
    update(dt) {
        let speed = 1;
        this.node.x += Math.random() * speed;
        this.node.y += Math.random() * speed;
        this.move();
    }

    /** 节点移动 */
    move() {
        let wd = cc.winSize.width;
        let ht = cc.winSize.height;
        let x = this.node.x + this.speedX
        if (x < this.node.width * 0.5 || x > wd - this.node.width * 0.5) {
            this.speedX *= -1;
        }
        this.node.x += this.speedX;
        let y = this.node.y + this.speedY;
        if (y < this.node.height * 0.5 || y > ht - this.node.height * 0.5) {
            this.speedY *= -1;
        }
        this.node.y += this.speedY;

    }

    /** 设置碰撞之后的状态 */
    public setIsCollision(isCollision) {
        this.isCollision = isCollision;
        if (isCollision) {
            this.node.color = cc.color(255, 0, 0);
        } else {
            this.node.color = cc.color(255, 255, 255);
        }
    }
}
