"use strict";
cc._RF.push(module, '7a020dA7mNHrZfAOfzRsazp', 'item');
// Script/item.ts

"use strict";
/*
 * @Author: 林武
 * @Date: 2022-06-01 10:23:34
 * @LastEditors: 林武
 * @LastEditTime: 2022-06-07 10:09:35
 * @FilePath: \QuadTree\assets\Script\item.ts
 * @Description:
 *
 * Copyright (c) 2022 by 林武/长沙游品, All Rights Reserved.
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var item = /** @class */ (function (_super) {
    __extends(item, _super);
    function item() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        /** 是否配置 */
        _this.isCollision = false;
        /** X轴的移动速度 */
        _this.speedX = 1;
        /** Y轴的移动速度 */
        _this.speedY = 1;
        return _this;
    }
    // onLoad () {}
    /** 生命周期：节点开始 */
    item.prototype.start = function () {
        this.speedX *= Math.random() > 0.5 ? -1 : 1;
        this.speedY *= Math.random() > 0.5 ? -1 : 1;
        this.node.x = Math.random() * cc.Canvas.instance.node.width;
        this.node.y = Math.random() * cc.Canvas.instance.node.height;
    };
    /** 生命周期：帧更新 */
    item.prototype.update = function (dt) {
        var speed = 1;
        this.node.x += Math.random() * speed;
        this.node.y += Math.random() * speed;
        this.move();
    };
    /** 节点移动 */
    item.prototype.move = function () {
        var wd = cc.winSize.width;
        var ht = cc.winSize.height;
        var x = this.node.x + this.speedX;
        if (x < this.node.width * 0.5 || x > wd - this.node.width * 0.5) {
            this.speedX *= -1;
        }
        this.node.x += this.speedX;
        var y = this.node.y + this.speedY;
        if (y < this.node.height * 0.5 || y > ht - this.node.height * 0.5) {
            this.speedY *= -1;
        }
        this.node.y += this.speedY;
    };
    /** 设置碰撞之后的状态 */
    item.prototype.setIsCollision = function (isCollision) {
        this.isCollision = isCollision;
        if (isCollision) {
            this.node.color = cc.color(255, 0, 0);
        }
        else {
            this.node.color = cc.color(255, 255, 255);
        }
    };
    item = __decorate([
        ccclass
    ], item);
    return item;
}(cc.Component));
exports.default = item;

cc._RF.pop();