
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/Script/CollisionQuadTree.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '42b1cQXif1ABqjcG+5LsV0L', 'CollisionQuadTree');
// Script/CollisionQuadTree.ts

"use strict";
/*
 * @Author: 林武
 * @Date: 2022-06-01 10:28:43
 * @LastEditors: 林武
 * @LastEditTime: 2022-06-09 10:24:18
 * @FilePath: \QuadTree\assets\Script\CollisionQuadTree.ts
 * @Description:
 *
 * Copyright (c) 2022 by 林武/长沙游品, All Rights Reserved.
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var QuadTree_1 = require("./QuadTree");
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var CollisionQuadTree = /** @class */ (function (_super) {
    __extends(CollisionQuadTree, _super);
    function CollisionQuadTree() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.graphics = null;
        _this.item = null;
        _this.btnTreeLabel = null;
        _this.ItemNum = null;
        _this.openQuadTree = true;
        // LIFE-CYCLE CALLBACKS:
        /** 生产的节点 */
        _this.nodes = [];
        /** 四叉树 */
        _this.quadTree = null;
        return _this;
    }
    /** 生命周期：加载 */
    CollisionQuadTree.prototype.onLoad = function () {
    };
    /** 生命周期：节点开始 */
    CollisionQuadTree.prototype.start = function () {
        this.btnTreeLabel.string = this.openQuadTree ? "关闭四叉树" : "开启四叉树";
        this.initQuadTree();
    };
    /** 初始化四叉树 */
    CollisionQuadTree.prototype.initQuadTree = function () {
        var bounds = {
            x: 0,
            y: 0,
            width: cc.Canvas.instance.node.width,
            height: cc.Canvas.instance.node.height
        };
        this.quadTree = new QuadTree_1.Quadtree(bounds);
        for (var i = 0; i < 500; i++) {
            var newNode = cc.instantiate(this.item);
            this.node.addChild(newNode);
            this.nodes.push(newNode);
            this.quadTree.insert(newNode);
        }
        this.ItemNum.string = "当前节点数量：" + this.nodes.length;
    };
    /** 切换四叉树状态按钮 */
    CollisionQuadTree.prototype.clickBtnTree = function () {
        this.openQuadTree = !this.openQuadTree;
        this.btnTreeLabel.string = this.openQuadTree ? "关闭四叉树" : "开启四叉树";
        if (!this.openQuadTree) {
            this.drawQuadTreeNodes();
        }
    };
    /** 增加节点数量按钮 */
    CollisionQuadTree.prototype.clickAddBtn = function () {
        for (var i = 0; i < 50; i++) {
            var newNode = cc.instantiate(this.item);
            this.node.addChild(newNode);
            this.nodes.push(newNode);
            this.quadTree.insert(newNode);
        }
        this.ItemNum.string = "当前节点数量：" + this.nodes.length;
    };
    /** 减少节点数量按钮 */
    CollisionQuadTree.prototype.clickSubtractBtn = function () {
        for (var i = 0; i < 50; i++) {
            var newNode = this.nodes[this.nodes.length - 1];
            this.nodes.splice(this.nodes.length - 1, 1);
            newNode.destroy();
        }
        this.quadTree.clear();
        this.ItemNum.string = "当前节点数量：" + this.nodes.length;
    };
    /** 普通碰撞检测 */
    CollisionQuadTree.prototype.normalCheck = function () {
        for (var _i = 0, _a = this.nodes; _i < _a.length; _i++) {
            var node = _a[_i];
            node.getComponent("item").setIsCollision(false);
        }
        for (var i = 0; i < this.nodes.length; i++) {
            var node = this.nodes[i];
            for (var j = 0; j < this.nodes.length; j++) {
                var targetNode = this.nodes[j];
                if (targetNode === node)
                    continue;
                var isCollision = targetNode.getBoundingBoxToWorld().intersects(node.getBoundingBoxToWorld());
                if (isCollision) {
                    node.getComponent("item").setIsCollision(isCollision);
                    targetNode.getComponent("item").setIsCollision(isCollision);
                }
            }
        }
    };
    /** 四叉树碰撞检测 */
    CollisionQuadTree.prototype.quadTreeCheck = function () {
        for (var _i = 0, _a = this.nodes; _i < _a.length; _i++) {
            var node = _a[_i];
            node.getComponent("item").setIsCollision(false);
            this.quadTree.insert(node);
        }
        // 绘制四叉树节点
        this.drawQuadTreeNodes();
        for (var i = 0; i < this.nodes.length; i++) {
            var node = this.nodes[i];
            var targetNodes = this.quadTree.retrieve(node);
            for (var j = 0; j < targetNodes.length; j++) {
                var targetNode = targetNodes[j];
                if (targetNode === node)
                    continue;
                var isCollision = targetNode.getBoundingBoxToWorld().intersects(node.getBoundingBoxToWorld());
                if (isCollision) {
                    node.getComponent("item").setIsCollision(isCollision);
                    targetNode.getComponent("item").setIsCollision(isCollision);
                }
            }
        }
        this.quadTree.clear();
    };
    /** 绘制四叉树节点 */
    CollisionQuadTree.prototype.drawQuadTreeNodes = function () {
        // 更新绘图节点位置
        this.graphics.getComponent(cc.Widget).updateAlignment();
        // 清除旧路径
        var graphics = this.graphics;
        graphics.clear();
        graphics.strokeColor = cc.color(0, 255, 0, 150);
        // 递归函数
        function creatPath(tree) {
            var subTrees = tree.nodes;
            // 是否有子节点？
            // 没有子节点才绘制路径
            if (subTrees.length === 0) {
                var rect = tree.bounds;
                graphics.rect(rect.x, rect.y, rect.width, rect.height);
            }
            else {
                // 递归子节点
                for (var i = 0; i < subTrees.length; i++) {
                    creatPath(subTrees[i]);
                }
            }
        }
        // 递归生成路径
        creatPath(this.quadTree);
        // 绘制路径
        graphics.stroke();
    };
    CollisionQuadTree.prototype.update = function (dt) {
        if (this.openQuadTree) {
            this.quadTreeCheck();
        }
        else {
            this.normalCheck();
        }
    };
    __decorate([
        property({ type: cc.Graphics, tooltip: CC_DEV && '绘图组件' })
    ], CollisionQuadTree.prototype, "graphics", void 0);
    __decorate([
        property({ type: cc.Prefab, tooltip: CC_DEV && '添加物体节点' })
    ], CollisionQuadTree.prototype, "item", void 0);
    __decorate([
        property({ type: cc.Label, tooltip: CC_DEV && '按钮文字' })
    ], CollisionQuadTree.prototype, "btnTreeLabel", void 0);
    __decorate([
        property({ type: cc.Label, tooltip: CC_DEV && '场景节点数量' })
    ], CollisionQuadTree.prototype, "ItemNum", void 0);
    __decorate([
        property({ displayName: CC_DEV && '是否启用四叉树' })
    ], CollisionQuadTree.prototype, "openQuadTree", void 0);
    CollisionQuadTree = __decorate([
        ccclass
    ], CollisionQuadTree);
    return CollisionQuadTree;
}(cc.Component));
exports.default = CollisionQuadTree;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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