
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/Script/QuadTree.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '4092ePTtXtEE60k2DFHurpN', 'QuadTree');
// Script/QuadTree.ts

"use strict";
/**
 * quadtree-js
 * @version 1.2.3
 * @license MIT
 * @author Timo Hausmann
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.Quadtree = void 0;
/* https://github.com/timohausmann/quadtree-js.git v1.2.3 */
/*
Copyright © 2012-2020 Timo Hausmann
Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:
The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.
THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/
var Quadtree = /** @class */ (function () {
    /**
     * Quadtree Constructor
     * @param Object bounds            bounds of the node { x, y, width, height }
     * @param Integer max_objects      (optional) max objects a node can hold before splitting into 4 subnodes (default: 10)
     * @param Integer max_levels       (optional) total max levels inside root Quadtree (default: 4)
     * @param Integer level            (optional) depth level, required for subnodes (default: 0)
     */
    function Quadtree(bounds, max_objects, max_levels, level) {
        this.max_objects = max_objects || 10;
        this.max_levels = max_levels || 4;
        this.level = level || 0;
        this.bounds = bounds;
        this.objects = [];
        this.nodes = [];
    }
    ;
    /**
     * Split the node into 4 subnodes
     */
    Quadtree.prototype.split = function () {
        var nextLevel = this.level + 1, subWidth = this.bounds.width / 2, subHeight = this.bounds.height / 2, x = this.bounds.x, y = this.bounds.y;
        //top right node
        this.nodes[0] = new Quadtree({
            x: x + subWidth,
            y: y,
            width: subWidth,
            height: subHeight
        }, this.max_objects, this.max_levels, nextLevel);
        //top left node
        this.nodes[1] = new Quadtree({
            x: x,
            y: y,
            width: subWidth,
            height: subHeight
        }, this.max_objects, this.max_levels, nextLevel);
        //bottom left node
        this.nodes[2] = new Quadtree({
            x: x,
            y: y + subHeight,
            width: subWidth,
            height: subHeight
        }, this.max_objects, this.max_levels, nextLevel);
        //bottom right node
        this.nodes[3] = new Quadtree({
            x: x + subWidth,
            y: y + subHeight,
            width: subWidth,
            height: subHeight
        }, this.max_objects, this.max_levels, nextLevel);
    };
    ;
    /**
     * Determine which node the object belongs to
     * @param Object pRect      bounds of the area to be checked, with x, y, width, height
     * @return Array            an array of indexes of the intersecting subnodes
     *                          (0-3 = top-right, top-left, bottom-left, bottom-right / ne, nw, sw, se)
     */
    Quadtree.prototype.getIndex = function (node) {
        var pRect = node.getBoundingBox();
        var indexes = [], verticalMidpoint = this.bounds.x + (this.bounds.width / 2), horizontalMidpoint = this.bounds.y + (this.bounds.height / 2);
        var startIsNorth = pRect.y < horizontalMidpoint, startIsWest = pRect.x < verticalMidpoint, endIsEast = pRect.x + pRect.width > verticalMidpoint, endIsSouth = pRect.y + pRect.height > horizontalMidpoint;
        //top-right quad
        if (startIsNorth && endIsEast) {
            indexes.push(0);
        }
        //top-left quad
        if (startIsWest && startIsNorth) {
            indexes.push(1);
        }
        //bottom-left quad
        if (startIsWest && endIsSouth) {
            indexes.push(2);
        }
        //bottom-right quad
        if (endIsEast && endIsSouth) {
            indexes.push(3);
        }
        return indexes;
    };
    ;
    /**
     * Insert the object into the node. If the node
     * exceeds the capacity, it will split and add all
     * objects to their corresponding subnodes.
     * @param Object pRect        bounds of the object to be added { x, y, width, height }
     */
    Quadtree.prototype.insert = function (node) {
        var i = 0, indexes;
        //if we have subnodes, call insert on matching subnodes
        if (this.nodes.length) {
            indexes = this.getIndex(node);
            for (i = 0; i < indexes.length; i++) {
                this.nodes[indexes[i]].insert(node);
            }
            return;
        }
        //otherwise, store object here
        this.objects.push(node);
        //max_objects reached
        if (this.objects.length > this.max_objects && this.level < this.max_levels) {
            //split if we don't already have subnodes
            if (!this.nodes.length) {
                this.split();
            }
            //add all objects to their corresponding subnode
            for (i = 0; i < this.objects.length; i++) {
                indexes = this.getIndex(this.objects[i]);
                for (var k = 0; k < indexes.length; k++) {
                    this.nodes[indexes[k]].insert(this.objects[i]);
                }
            }
            //clean up this node
            this.objects = [];
        }
    };
    ;
    /**
     * Return all objects that could collide with the given object
     * @param Object pRect      bounds of the object to be checked { x, y, width, height }
     * @return Array            array with all detected objects
     */
    Quadtree.prototype.retrieve = function (node) {
        var indexes = this.getIndex(node), returnObjects = this.objects;
        //if we have subnodes, retrieve their objects
        if (this.nodes.length) {
            for (var i = 0; i < indexes.length; i++) {
                returnObjects = returnObjects.concat(this.nodes[indexes[i]].retrieve(node));
            }
        }
        //remove duplicates
        returnObjects = returnObjects.filter(function (item, index) {
            return returnObjects.indexOf(item) >= index;
        });
        return returnObjects;
    };
    ;
    /**
     * Clear the quadtree
     */
    Quadtree.prototype.clear = function () {
        this.objects = [];
        for (var i = 0; i < this.nodes.length; i++) {
            if (this.nodes.length) {
                this.nodes[i].clear();
            }
        }
        this.nodes = [];
    };
    ;
    return Quadtree;
}());
exports.Quadtree = Quadtree;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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