"use strict";
cc._RF.push(module, '42b1cQXif1ABqjcG+5LsV0L', 'CollisionQuadTree');
// Script/CollisionQuadTree.ts

"use strict";
/*
 * @Author: 林武
 * @Date: 2022-06-01 10:28:43
 * @LastEditors: 林武
 * @LastEditTime: 2022-06-09 10:24:18
 * @FilePath: \QuadTree\assets\Script\CollisionQuadTree.ts
 * @Description:
 *
 * Copyright (c) 2022 by 林武/长沙游品, All Rights Reserved.
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var QuadTree_1 = require("./QuadTree");
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var CollisionQuadTree = /** @class */ (function (_super) {
    __extends(CollisionQuadTree, _super);
    function CollisionQuadTree() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.graphics = null;
        _this.item = null;
        _this.btnTreeLabel = null;
        _this.ItemNum = null;
        _this.openQuadTree = true;
        // LIFE-CYCLE CALLBACKS:
        /** 生产的节点 */
        _this.nodes = [];
        /** 四叉树 */
        _this.quadTree = null;
        return _this;
    }
    /** 生命周期：加载 */
    CollisionQuadTree.prototype.onLoad = function () {
    };
    /** 生命周期：节点开始 */
    CollisionQuadTree.prototype.start = function () {
        this.btnTreeLabel.string = this.openQuadTree ? "关闭四叉树" : "开启四叉树";
        this.initQuadTree();
    };
    /** 初始化四叉树 */
    CollisionQuadTree.prototype.initQuadTree = function () {
        var bounds = {
            x: 0,
            y: 0,
            width: cc.Canvas.instance.node.width,
            height: cc.Canvas.instance.node.height
        };
        this.quadTree = new QuadTree_1.Quadtree(bounds);
        for (var i = 0; i < 500; i++) {
            var newNode = cc.instantiate(this.item);
            this.node.addChild(newNode);
            this.nodes.push(newNode);
            this.quadTree.insert(newNode);
        }
        this.ItemNum.string = "当前节点数量：" + this.nodes.length;
    };
    /** 切换四叉树状态按钮 */
    CollisionQuadTree.prototype.clickBtnTree = function () {
        this.openQuadTree = !this.openQuadTree;
        this.btnTreeLabel.string = this.openQuadTree ? "关闭四叉树" : "开启四叉树";
        if (!this.openQuadTree) {
            this.drawQuadTreeNodes();
        }
    };
    /** 增加节点数量按钮 */
    CollisionQuadTree.prototype.clickAddBtn = function () {
        for (var i = 0; i < 50; i++) {
            var newNode = cc.instantiate(this.item);
            this.node.addChild(newNode);
            this.nodes.push(newNode);
            this.quadTree.insert(newNode);
        }
        this.ItemNum.string = "当前节点数量：" + this.nodes.length;
    };
    /** 减少节点数量按钮 */
    CollisionQuadTree.prototype.clickSubtractBtn = function () {
        for (var i = 0; i < 50; i++) {
            var newNode = this.nodes[this.nodes.length - 1];
            this.nodes.splice(this.nodes.length - 1, 1);
            newNode.destroy();
        }
        this.quadTree.clear();
        this.ItemNum.string = "当前节点数量：" + this.nodes.length;
    };
    /** 普通碰撞检测 */
    CollisionQuadTree.prototype.normalCheck = function () {
        for (var _i = 0, _a = this.nodes; _i < _a.length; _i++) {
            var node = _a[_i];
            node.getComponent("item").setIsCollision(false);
        }
        for (var i = 0; i < this.nodes.length; i++) {
            var node = this.nodes[i];
            for (var j = 0; j < this.nodes.length; j++) {
                var targetNode = this.nodes[j];
                if (targetNode === node)
                    continue;
                var isCollision = targetNode.getBoundingBoxToWorld().intersects(node.getBoundingBoxToWorld());
                if (isCollision) {
                    node.getComponent("item").setIsCollision(isCollision);
                    targetNode.getComponent("item").setIsCollision(isCollision);
                }
            }
        }
    };
    /** 四叉树碰撞检测 */
    CollisionQuadTree.prototype.quadTreeCheck = function () {
        for (var _i = 0, _a = this.nodes; _i < _a.length; _i++) {
            var node = _a[_i];
            node.getComponent("item").setIsCollision(false);
            this.quadTree.insert(node);
        }
        // 绘制四叉树节点
        this.drawQuadTreeNodes();
        for (var i = 0; i < this.nodes.length; i++) {
            var node = this.nodes[i];
            var targetNodes = this.quadTree.retrieve(node);
            for (var j = 0; j < targetNodes.length; j++) {
                var targetNode = targetNodes[j];
                if (targetNode === node)
                    continue;
                var isCollision = targetNode.getBoundingBoxToWorld().intersects(node.getBoundingBoxToWorld());
                if (isCollision) {
                    node.getComponent("item").setIsCollision(isCollision);
                    targetNode.getComponent("item").setIsCollision(isCollision);
                }
            }
        }
        this.quadTree.clear();
    };
    /** 绘制四叉树节点 */
    CollisionQuadTree.prototype.drawQuadTreeNodes = function () {
        // 更新绘图节点位置
        this.graphics.getComponent(cc.Widget).updateAlignment();
        // 清除旧路径
        var graphics = this.graphics;
        graphics.clear();
        graphics.strokeColor = cc.color(0, 255, 0, 150);
        // 递归函数
        function creatPath(tree) {
            var subTrees = tree.nodes;
            // 是否有子节点？
            // 没有子节点才绘制路径
            if (subTrees.length === 0) {
                var rect = tree.bounds;
                graphics.rect(rect.x, rect.y, rect.width, rect.height);
            }
            else {
                // 递归子节点
                for (var i = 0; i < subTrees.length; i++) {
                    creatPath(subTrees[i]);
                }
            }
        }
        // 递归生成路径
        creatPath(this.quadTree);
        // 绘制路径
        graphics.stroke();
    };
    CollisionQuadTree.prototype.update = function (dt) {
        if (this.openQuadTree) {
            this.quadTreeCheck();
        }
        else {
            this.normalCheck();
        }
    };
    __decorate([
        property({ type: cc.Graphics, tooltip: CC_DEV && '绘图组件' })
    ], CollisionQuadTree.prototype, "graphics", void 0);
    __decorate([
        property({ type: cc.Prefab, tooltip: CC_DEV && '添加物体节点' })
    ], CollisionQuadTree.prototype, "item", void 0);
    __decorate([
        property({ type: cc.Label, tooltip: CC_DEV && '按钮文字' })
    ], CollisionQuadTree.prototype, "btnTreeLabel", void 0);
    __decorate([
        property({ type: cc.Label, tooltip: CC_DEV && '场景节点数量' })
    ], CollisionQuadTree.prototype, "ItemNum", void 0);
    __decorate([
        property({ displayName: CC_DEV && '是否启用四叉树' })
    ], CollisionQuadTree.prototype, "openQuadTree", void 0);
    CollisionQuadTree = __decorate([
        ccclass
    ], CollisionQuadTree);
    return CollisionQuadTree;
}(cc.Component));
exports.default = CollisionQuadTree;

cc._RF.pop();