import { _decorator, Component, Node, Vec3, misc, Quat, quat, Collider2D, Contact2DType, IPhysics2DContact, log } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('ColliderListener')
export class ColliderListener extends Component {
    // @property
    angle: number = 0;

    private collider: Collider2D = null;

    onLoad() {
        this.collider = this.getComponent(Collider2D);
        if (this.collider) {
            this.collider.on(Contact2DType.BEGIN_CONTACT, this.onBeginContact, this);
            this.collider.on(Contact2DType.END_CONTACT, this.onEndContact, this);
            this.collider.on(Contact2DType.PRE_SOLVE, this.onPreSolve, this);
            this.collider.on(Contact2DType.POST_SOLVE, this.onPostSolve, this);
        }
    }

    init(angle: number, group: number) {
        this.angle = angle;
        if (this.collider) {
            this.collider.group = group;
        }
    }

    start() {
        // if (this.angle > 0) {
        //     this.scheduleOnce(()=>{
        //         this.collider.enabled = false;
        //     }, 3);            
        // }
    }

    unuse() {
        // log("unuse");
    }

    reuse(args: any) {
        // log("reuse");
    }

    onBeginContact (selfCollider: Collider2D, otherCollider: Collider2D, contact: IPhysics2DContact | null) {
        log("selfCollider: " + selfCollider.enabled + "; otherCollider: " + otherCollider.enabled);
    }

    onEndContact (selfCollider: Collider2D, otherCollider: Collider2D, contact: IPhysics2DContact | null) {
        
    }

    onPreSolve (selfCollider: Collider2D, otherCollider: Collider2D, contact: IPhysics2DContact | null) {
        
    }

    onPostSolve (selfCollider: Collider2D, otherCollider: Collider2D, contact: IPhysics2DContact | null) {
        
    }

    update(deltaTime: number) {
        if (this.angle != 0) {
            this.rotateByAxis(Vec3.UNIT_Z, this.angle);
        }
    }

    rotateByAxis(axis: Vec3, angle: number) {
        let rotation = quat();
        let rad = misc.degreesToRadians(angle);
        // 绕世界空间下指定轴旋转四元数: 四元数绕指定轴旋转指定弧度后的四元数
        Quat.rotateAround(rotation, this.node.rotation, axis, rad);
        this.node.rotation = rotation;
    }
}

