import { _decorator, Component, Node, resources, Prefab, NodePool, isValid, instantiate, Vec3, v3 } from 'cc';
import { ColliderListener } from './ColliderListener';
const { ccclass, property } = _decorator;

@ccclass('Demo')
export class Demo extends Component {
    private pool: NodePool = new NodePool(ColliderListener);
    start() {
        this.spawnCollider("A", v3(-100,0,0), 1, 2);
        this.spawnCollider("B", v3(100,0,0), -1, 4);
    }

    private spawnCollider(name: string, pos: Vec3, angle: number, group: number) {
        this.spawnColliderNode().then((node: Node)=>{
            if (node) {
                node.name = name;
                node.setParent(this.node);
                node.setPosition(pos);

                let collider = node.getComponent(ColliderListener);
                if (collider) {
                    collider.init(angle, group);
                }
            }
        });
    }

    private spawnColliderNode(): Promise<Node> {
        return new Promise((resolve, reject) => {
            let node = this.pool.get();
            if (isValid(node)) {
                resolve(node);
            } else {
                resources.load<Prefab>("Collider", (err: Error, prefab: Prefab)=>{
                    if (err) {
                        reject(null);
                    }
    
                    node = instantiate(prefab);
                    resolve(node);
                });
            }
        });
    }

    update(deltaTime: number) {
        
    }
}

