import { _decorator, Component, Node, Camera, Vec3 } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('DragStuff')
export class DragStuff extends Component {

  @property(Camera) 
  ownCamera: Camera = null!;

  private _isTouched = false;

  start() {
    console.log()
    this.node.on('touch-start', this._touchStart, this);
    this.node.on('touch-end', this._touchEnd, this);
    this.node.on('touch-move', this._touchMove, this);
  }

  _touchStart() {
    this._isTouched = true;
  }
  _touchEnd() {
    this._isTouched = false;
  }
  _touchMove(touch) {
    if (this._isTouched) {
      const position = this.node.getPosition();
      
      var touchLoc = touch.getLocation();
      var touchLocV3 = this.ownCamera.screenToWorld(new Vec3(touchLoc.x, touchLoc.y, 0));
      var pos = this.ownCamera.convertToUINode(touchLocV3, this.node.parent!);

      this.node.setPosition(pos);
    }
  }

  update(deltaTime: number) {
      
  }
}

