import RenderFlowExt from "./RenderFlowExt";

const { ccclass, property } = cc._decorator;
@ccclass
export default class Test extends cc.Component {

    @property(cc.Node)
    content: cc.Node = null

    @property(cc.Node)
    itemMaster: cc.Node = null

    @property(cc.Node)
    btnContent: cc.Node = null

    @property(cc.Node)
    btnMaster: cc.Node = null

    @property(cc.Font)
    font: cc.Font = null

    protected itemLabelArr: cc.Label[] = []
    protected btnArr: cc.Node[] = []
    protected btnLabelArr: cc.Label[] = []

    protected onLoad() {
        RenderFlowExt.init()

        for (let i = 0; i < 100; i++) {
            let item = cc.instantiate(this.itemMaster)
            item.setParent(this.content)
            item.active = true
            item.name = `item_${i}`
            let label = cc.find("content/label", item).getComponent(cc.Label)
            label.string = `` + i
            this.itemLabelArr.push(label)
        }

        this.newBtn(`使用层级渲染`, (e: cc.Event.EventTouch, icon: cc.Node) => {
            icon.active = true
            if (icon.active) {
                this.content["__enableLevelRender"] = true
                this.btnContent["__enableLevelRender"] = true
            } else {
                // this.content["__enableLevelRender"] = false
                // this.content["__levelRender"] = null
                // this.btnContent["__enableLevelRender"] = false
                // this.btnContent["__levelRender"] = null
            }
        })

        let cb = (cacheMode: cc.Label.CacheMode) => {
            this.itemLabelArr.forEach((label) => { label.cacheMode = cacheMode })
            this.btnLabelArr.forEach((label) => { label.cacheMode = cacheMode })
            this.btnArr.forEach((btn, i) => {
                let icon = cc.find("content/mark/icon", btn)
                switch (cacheMode) {
                    case cc.Label.CacheMode.NONE:
                        if (i === 0) icon.active = true
                        else icon.active = false
                        break;
                    case cc.Label.CacheMode.BITMAP:
                        if (i === 1) icon.active = true
                        else icon.active = false
                        break;
                    case cc.Label.CacheMode.CHAR:
                        if (i === 2) icon.active = true
                        else icon.active = false
                        break;
                    default:
                        if (i === 0) icon.active = true
                        else icon.active = false
                        break;
                }
            })
        }

        this.btnArr.push(this.newBtn(`label模式:NONE`, (e: cc.Event.EventTouch, icon: cc.Node) => {
            cb(cc.Label.CacheMode.NONE)
        }))

        this.btnArr.push(this.newBtn(`label模式:BITMAP`, (e: cc.Event.EventTouch, icon: cc.Node) => {
            cb(cc.Label.CacheMode.BITMAP)
        }))

        this.btnArr.push(this.newBtn(`label模式:CHAR`, (e: cc.Event.EventTouch, icon: cc.Node) => {
            cb(cc.Label.CacheMode.CHAR)
        }))

        cb(cc.Label.CacheMode.NONE)

        this.newBtn(`使用位图字体`, (e: cc.Event.EventTouch, icon: cc.Node) => {
            icon.active = !icon.active
            if (icon.active)
                this.itemLabelArr.forEach((label) => { label.font = this.font })
            else
                this.itemLabelArr.forEach((label) => { label.font = null })
        })

    }

    protected newBtn(key: string, callBack: Function) {
        let btn = cc.instantiate(this.btnMaster)
        btn.setParent(this.btnContent)
        btn.active = true
        btn.name = key
        let mark = cc.find("content/mark", btn)
        let icon = cc.find("icon", mark)
        icon.active = false
        let label = cc.find("content/label", btn).getComponent(cc.Label)
        label.string = key
        this.btnLabelArr.push(label)
        btn.on(cc.Node.EventType.TOUCH_END, (e) => {
            callBack && callBack(e, icon)
        }, this)
        return btn
    }

}