import { Component, Texture2D, DynamicAtlasManager, Sprite, SpriteFrame, UITransform , Node, _decorator, dynamicAtlasManager, macro, AssetManager, assetManager, Canvas, Layers, Layout, ScrollView, director, isValid, v3, view } from "cc";
const { ccclass, property } = _decorator;
class DebugUtils {

    _debugNode: Node = null;

    showDynamicAtlasDebug(show) {

        let canvas = director.getScene().getComponentInChildren(Canvas)?.node;

        let mgr = dynamicAtlasManager;

        console.log(`DebugUtils-> ${mgr.enabled},${macro.CLEANUP_IMAGE_CACHE}`);

        let _debugNode = this._debugNode;

        if (show) {

            let addToScene = (content) => {

                let fn = (atlasObj) => {

                    // @ts-ignore

                    for (let i = 0; i <= atlasObj._atlasIndex; i++) {

                        let node = new Node(atlasObj.name || 'ATLAS');

                        node.layer = Layers.Enum.UI_2D;

                        // @ts-ignore

                        let texture = atlasObj._atlases[i]._texture;

                        let spriteFrame = new SpriteFrame();

                        spriteFrame.texture = texture;

                        let sprite = node.addComponent(Sprite);

                        sprite.spriteFrame = spriteFrame;

                        node.parent = content;

                    }

                }

                fn(mgr);

            }

            if (!_debugNode || !_debugNode.isValid) {

                let width = view.getVisibleSize().width;

                let height = view.getVisibleSize().height;

                _debugNode = new Node('DYNAMIC_ATLAS_DEBUG_NODE');

                let transform = _debugNode.addComponent(UITransform);

                transform.width = width;

                transform.height = height;

                _debugNode.setSiblingIndex(999);

                _debugNode.parent = canvas;

                _debugNode.layer = Layers.Enum.UI_2D;

                let scroll = _debugNode.addComponent(ScrollView);

                let content = new Node('CONTENT');

                let layout = content.addComponent(Layout);

                layout.type = Layout.Type.VERTICAL;

                layout.resizeMode = Layout.ResizeMode.CONTAINER;

                let contentTR = content.addComponent(UITransform);

                content.parent = _debugNode;

                contentTR.width = mgr.textureSize;

                contentTR.anchorY = 1;

                content.position = v3(mgr.textureSize, 0, 0);

                content.layer = Layers.Enum.UI_2D;

                scroll.content = content;

                addToScene(content);

                this._debugNode = _debugNode;

            } else {

                let content = _debugNode.getChildByName("CONTENT");

                content.destroyAllChildren();

                addToScene(content);

            }

            return _debugNode;

        }

        else {

            if (_debugNode && isValid(_debugNode)) {

                _debugNode.parent = null;

                _debugNode.destroy();

            }

        }

        this._debugNode = _debugNode;

    }

}

@ccclass('ShowDynamicAtlas')
export class ShowDynamicAtlas extends Component {
    start() {
        assetManager.loadBundle("AAAAAAAA",undefined,this.LoadBundleHandle.bind(this,"AAAAAAAA",( a , b  , c  ,d  )=>{
            console.log( "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA")
        }));
        return true;
    }
    
    private LoadBundleHandle(bundleName:string,completeHandle:(bundleName:string,isComplete:boolean)=>void | undefined,err: Error | null, bundle: AssetManager.Bundle):void{
        completeHandle(bundleName,err == undefined);//不可为空
    } 
    isShow = true; 
    qqq = new DebugUtils();
    buttonHandle(){
        this.qqq.showDynamicAtlasDebug( this.isShow );
        this.isShow = !this.isShow;
    }
} 

macro.CLEANUP_IMAGE_CACHE = false;
dynamicAtlasManager.enabled = true;
dynamicAtlasManager.maxFrameSize = 512;          