import {
    _decorator,
    Component,
    EPhysics2DDrawFlags,
    ERaycast2DType,
    EventTouch,
    Graphics,
    log,
    Node,
    PhysicsSystem2D,
    UITransform,
    Vec2,
    Vec3,
} from "cc";
const { ccclass, property } = _decorator;

@ccclass("NewComponent")
export class NewComponent extends Component {
    onLoad() {
        this.graphic_line.node.on(Node.EventType.TOUCH_START, this.onTouchStart, this);
        this.graphic_line.node.on(Node.EventType.TOUCH_MOVE, this.onTouchMove, this);
        this.graphic_line.node.on(Node.EventType.TOUCH_END, this.onTouchEnd, this);
        this.graphic_line.node.on(Node.EventType.TOUCH_CANCEL, this.onTouchEnd, this);
    }
    start() {
        PhysicsSystem2D.instance.enable = true;

        PhysicsSystem2D.instance.debugDrawFlags =
            EPhysics2DDrawFlags.Aabb |
            EPhysics2DDrawFlags.Pair |
            EPhysics2DDrawFlags.CenterOfMass |
            EPhysics2DDrawFlags.Joint |
            EPhysics2DDrawFlags.Shape;

        // const results = PhysicsSystem2D.instance.raycast(
        //     new Vec2(-640, 320),
        //     new Vec2(640, 320),
        //     ERaycast2DType.Closest,
        //     -1
        // );

        // console.log(results);
    }

    @property({ type: Graphics, tooltip: "瞄准线作图" })
    graphic_line: Graphics = null;

    AIM_LINE_MAX_LENGTH = 1440;

    private onTouchStart() {
        this.graphic_line.clear();
    }
    private onTouchEnd() {
        this.graphic_line.clear();
    }

    private _cur_length: number = 0;
    private onTouchMove(touch: EventTouch) {
        this.graphic_line.clear();
        this._cur_length = 0; //已经绘制了多少

        //应该都是世界坐标
        let Sp = new Vec2(0, 320); //发射点
        let endPos = new Vec2(900, 320); //结束点
        endPos = touch.getLocation(); //触摸的世界坐标
        // log(endPos.x, endPos.y);

        // //测试世界坐标转换
        // let t = this.graphic_line.node.getComponent(UITransform);
        // let vec = t.convertToWorldSpaceAR(new Vec3(0, 0));

        // log("00局部坐标转世界：", vec.x, vec.y);
        // let vecTest = new Vec2(2, 2).subtract(new Vec2(1, 1));
        // log("vecTest:", "[", vecTest.x, vecTest.y, "]", vecTest.normalize()); //[2,2]

        let endP = endPos.subtract(Sp); //结束点到起始点的向量
        // Sp = endP;

        let EpN = endP.normalize(); //单位向量

        this.drawRayCast(Sp, EpN);
        this.graphic_line.stroke();
    }

    /**
     * @description 计算射线
     * @param startLocation 起始位置 世界坐标系
     * @param vector_dir 单位方向向量
     */
    private drawRayCast(startLocation: Vec2, vector_dir: Vec2) {
        // 剩余长度
        const left_length = this.AIM_LINE_MAX_LENGTH - this._cur_length;
        if (left_length <= 0) return;
        // 计算线的终点位置

        let endLocation = vector_dir.multiplyScalar(left_length);
        // endLocation = startLocation.add(vector_dir.multiplyScalar(left_length));

        const results = PhysicsSystem2D.instance.raycast(
            startLocation,
            endLocation,
            ERaycast2DType.Closest
        );
        log(results.length);

        if (results.length) {
            const result = results[0];
            // 指定射线与穿过的碰撞体在哪一点相交。
            const point = result.point;
            // 画入射线段
            this.drawAimLine(startLocation, point);
            // 计算长度
            const line_length = point.subtract(startLocation).length();
            // 计算已画长度
            this._cur_length += line_length;
            // 指定碰撞体在相交点的表面的法线单位向量。
            const vector_n = result.normal;
            // 入射单位向量
            const vector_i = vector_dir;
            // 反射单位向量
            const vector_r = vector_i.subtract(vector_n.multiplyScalar(2 * vector_i.dot(vector_n)));
            // 接着计算下一段
            this.drawRayCast(point, vector_r);
        } else {
            // 画剩余线段
            this.drawAimLine(startLocation, endLocation);
        }
    }

    /**
     * @description 画瞄准线
     * @param startLocation 起始位置 世界坐标系
     * @param endLocation 结束位置 世界坐标系
     */
    private drawAimLine(startLocation: Vec2, endLocation: Vec2) {
        // const graphic_startLocation = this.graphic_line.node.convertToNodeSpaceAR(startLocation);
        let transform = this.graphic_line.node.getComponent(UITransform);
        const graphic_startLocation = transform.convertToNodeSpaceAR(
            new Vec3(startLocation.x, startLocation.y)
        );
        this.graphic_line.moveTo(graphic_startLocation.x, graphic_startLocation.y);
        // 画小圆圆
        // 间隔
        const delta = 20;
        // 方向
        const vector_dir = endLocation.subtract(startLocation);
        // 数量
        const total_count = Math.round(vector_dir.length() / delta);
        // 每次间隔向量​
        vector_dir.normalize().multiplyScalar(delta);

        for (let index = 0; index < total_count; index++) {
            graphic_startLocation.add(new Vec3(vector_dir.x, vector_dir.y));
            this.graphic_line.circle(graphic_startLocation.x, graphic_startLocation.y, 2);
        }
    }
}
