import { AudioClip, AudioSource } from "cc";

export interface ControllableAudioResource{
    play():any,
    pause():any,
    stop():any,
    currentTime:number,
    duration:number,
    volume:number,
    onEnded(f:()=>void):void,
}

export class AudioDecrator extends AudioSource{
    constructor(clip?:AudioClip){
        super();
        if (clip) this.clip = clip;
    }

    onEnded(f:()=>void){
        let o = ()=>{ //The Player for the Clip is created asynchronized. It is processed inside AudioSource.
            if (this._player){
                this._player.onEnded(f);
            }else{
                setTimeout(o, 0.1);
            }
        }
        o();
    }

    // clone(){
    //     return Object.assign(new AudioDecrator, this);
    // }
}

export abstract class AudioChannel<resource extends ControllableAudioResource>{
    abstract get volume():number;
    abstract set volume(n:number);
    abstract play(audio?: resource):boolean;
    abstract playInstantly(audio: resource):void;
    abstract pause():resource|resource[]|null;
    abstract stop():resource|resource[]|null;
    abstract clear():resource|resource[]|null;
    abstract update?(dt:number):void;
    abstract getCurrent():resource|resource[]|null;
    abstract onEnd(...args:any):void;
}