import { resources } from "cc";
import { AudioChannel, ControllableAudioResource } from "./AudioChannel";



export class ExclusiveChannel<resource extends ControllableAudioResource> extends AudioChannel<resource>{
    protected current: resource|null = null;
    protected _volume = 1;
    public isLoop = true;
    
    get volume(){
        return this._volume;
    }
    set volume(n:number){
        this._volume = n;
        //this.current?.setVolume(n, true);
        if (this.current) this.current.volume = n;
    }

    play(audio?: resource){
        if (audio){
            if (this.current){
                return false;
            }else{
                this.current = audio;
                //this.current.setVolume(this._volume);
                if (this.current) this.current.volume = this._volume;
                audio.onEnded(this.onEnd.bind(this));
                audio.play();
            }
        }else{
            this.current?.play();
        }
        return true;
    }

    playInstantly(audio: resource){
        // this.current?.stop();
        // this.current = audio;
        // // this.current.setVolume(this._volume);
        // if (this.current) this.current.volume = this._volume;
        // audio.onEnded(this.onEnd.bind(this));
        // audio.play();
        this.clear();
        this.play(audio);
    }

    pause(){
        this.current?.pause();
        return this.current;
    }

    stop(){
        this.current?.stop();
        return this.current;
    }

    clear(){
        let r = this.current;
        this.current?.stop();
        return r;
    }

    getCurrent(){
        return this.current;
    }

    update(deltaTime:number){
        return;
        // if (this.current){
        //     if (this.current.currentTime >= this.current.duration){
        //         if (this.isLoop){
        //             this.current.stop();
        //             this.current.play();
        //         }else{
        //             this.current = null;
        //         }
        //     }
        // }
    }

    onEnd(){
        if (this.current){
            if (this.isLoop){
                this.current.stop();
                this.current.play();
            }else{
                this.current = null;
            }
        }
    }
}