import { AudioChannel, ControllableAudioResource } from "./AudioChannel";



export class LoopChannel<resource extends ControllableAudioResource> extends AudioChannel<resource>{
    protected _interval = 0;
    protected _currentInterval:number = -1;

    protected list: resource[] = [];
    protected current: resource|null = null;
    protected pointer = 0;
    protected _volume = 1;
    
    get interval(){
        return this._interval;
    }
    get volume(){
        return this._volume;
    }
    set volume(n:number){
        this._volume = n;
        // this.current?.setVolume(n, true);
        if (this.current) this.current.volume = n;
    }

    constructor(interval:number = 0){
        super();
        this._interval = interval;
    }

    play(audio?: resource){
        if (audio){
            audio.onEnded(this.onEnd.bind(this));
            if (this.current){
                // audio.setVolume(this._volume);
                this.list.splice(this.pointer+1, 0, audio);
                return false;
            }else{
                this.list.splice(this.pointer, 0, audio);
                audio.volume = this._volume;
                audio.play();
                this.current = audio;
            }
        }else{
            if (this.current){
                this.current.play();
            }else{
                if (this._currentInterval >= 0){
                    if (this._interval>0){
                        this._currentInterval = setTimeout(()=>{
                            this.current = null;
                            this._currentInterval = -1;
                            this.play();
                        }, this._interval*1000);
                    }
                }else{
                    if (++this.pointer>=this.list.length){
                        this.pointer = 0;
                    }
                    let a = this.list[this.pointer];
                    if (a){
                        this.current = a;
                        //a.setVolume(this._volume);
                        a.volume = this._volume;
                        a.play();
                    }
                }
            }
        }
        return true;
    }

    playInstantly(audio: resource){
        let p = this.current?++this.pointer:this.pointer;
        this.stop();
        this.current = null;
        this.list.splice(p, 0, audio);
        audio.volume = this._volume;
        audio.onEnded(this.onEnd.bind(this));
        audio.play();
        this.current = audio;
    }

    add(audio:resource){
        this.list.splice(this.pointer, 0, audio);
        if (++this.pointer>this.list.length) this.pointer = 0;
        audio.volume = this._volume;
        audio.onEnded(this.onEnd.bind(this));
    }

    pause(){
        let c = null;
        if (this._currentInterval >= 0){
            clearInterval(this._currentInterval);
            this.current = null;
        }else{
            this.current?.stop();
            c = this.current;
        }
        return c;
    }

    stop(){
        let c = null;
        if (this._currentInterval >= 0){
            clearInterval(this._currentInterval);
            this._currentInterval = -1;
            this.current = null;
        }else{
            this.current?.stop();
            this._currentInterval = -1;
            c = this.current;
        }
        return c;
    }

    clear(){
        if (this.current){
            this.current.stop();
        }
        clearInterval(this._currentInterval);
        this._currentInterval = -1;
        let r = this.list;
        this.list = [];
        return r;
    }

    getCurrent(){
        return this.current;
    }

    update(deltaTime:number){
        return;
        // if (this.current){
        //     if (this.current.currentTime >= this.current.duration){
        //         this.current = null;
        //         this.play();
        //     }
        // }
    }

    onEnd(){
        if (this.current){
            if (this._interval>0){
                this._currentInterval = setTimeout(()=>{
                    this.current = null;
                    this._currentInterval = -1;
                    this.play();
                }, this._interval*1000);
            }else{
                this.current = null;
                this.play();
            }
        }
    }
}