import { resources } from "cc";
import { AudioChannel, ControllableAudioResource } from "./AudioChannel";


export class MixChannel<resource extends ControllableAudioResource> extends AudioChannel<resource>{
    protected audios: resource[] = [];
    protected _volume = 1;
    
    get volume(){
        return this._volume;
    }
    set volume(n:number){
        let dr = (n - this._volume)/this._volume;
        for (let v of this.audios){
            let o = v.volume;
            //v.volume(o * dr, true);
            v.volume = o * dr;
        }
    }

    play(audio: resource, volume?:number){
        if (!audio) return false;
        this.audios.push(audio);
        //audio.setVolume(volume ?? this._volume);
        audio.volume = volume ?? this._volume;
        audio.onEnded(this.onEnd.bind(this, audio));
        audio.play();
        return true;
    }

    playInstantly(audio: resource){
        this.clear();
        this.play(audio);
    }

    pause(){
        for (let v of this.audios){
            v.pause();
        }
        return this.audios;
    }

    stop(){
        for (let v of this.audios){
            v.stop();
        }
        return this.audios;
    }

    clear(){
        for (let v of this.audios){
            v.stop();
        }
        let r = this.audios;
        this.audios = [];
        return r;
    }

    getCurrent(){
        return this.audios;
    }

    update(deltaTime:number){
        return;
        // let l = [];
        // for (let i in this.audios){
        //     let v = this.audios[i];
        //     if (v.currentTime >= v.duration){
        //         l.push(i);
        //     }
        // }
        // for (let i of l){
        //     this.audios.splice(i as any);
        // }
    }

    onEnd(r:resource){
        let i = this.audios.indexOf(r);
        if (i>=0){
            this.audios.splice(i);
        }
    }
}