/**
 * 遮罩Sprite
 */
const {ccclass, property} = cc._decorator;

@ccclass
export default class MaskSprite extends cc.Sprite {
    /**
     * 遮罩图像
     */
    @property(cc.SpriteFrame)
    _maskFrame: cc.SpriteFrame = null;

    @property(cc.SpriteFrame)
    set maskFrame(value: cc.SpriteFrame) {
        this._maskFrame = value;
        this._applyMaskFrame();
    }
    get maskFrame() {
        return this._maskFrame;
    }
    
    _validateRender () {
        // @ts-ignore
        let spriteFrame = this._spriteFrame;
        let maskFrame = this._maskFrame;
        // @ts-ignore
        if (this._materials[0] &&
            spriteFrame && 
            spriteFrame.textureLoaded() &&
            maskFrame && 
            maskFrame.textureLoaded()) {
            return;
        }

        // @ts-ignore
        this.disableRender();
    }

    _updateMaterial () {
        let texture = this._maskFrame && this._maskFrame.getTexture();
        let material = this.getMaterial(0);
        material && material.setProperty('mask', texture);

        //@ts-ignore
        super._updateMaterial();
    }

    _applyMaskFrame() {
        this._updateMaterial();
        if(!this._maskFrame){
            // @ts-ignore
            this.disableRender();
        }else{
            // @ts-ignore
            this.setVertsDirty();
        }
        if (CC_EDITOR) {
            // @ts-ignore
            this._applyAtlas(this._maskFrame);
        }
    }
}
