const w = 40;
const d = 24;

@cc._decorator.ccclass
export default class Main extends cc.Component {

    private bundle: cc.AssetManager.Bundle;
    private spNamess: { [key: string]: Array<string> };
    private container: cc.Node;

    protected start(): void {

        console.log(cc.macro.CLEANUP_IMAGE_CACHE);
        cc.macro.CLEANUP_IMAGE_CACHE = true;

        this.container = this.node.getChildByName("container");

        const _btns = this.node.getChildByName("btns");
        _btns.getChildByName("加载bundle").on(cc.Node.EventType.TOUCH_START, () => {
            wx.loadSubpackage({
                name: "res", success: (res: { errMsg: string }) => {//{"errMsg":"loadSubpackage:ok"}
                    console.log("loadSubpackage(" + "res" + ") success " + JSON.stringify(res));
                    cc.assetManager.loadBundle("res", (err, bundle) => {
                        this.bundle = bundle;
                        this.spNamess = {};
                        for (const path in this.bundle._config.paths._map) {
                            const matchArr = path.match(/^Texture\/([^\/]+)\/([^\/]+)$/);
                            const spsName = matchArr[1];
                            let spNames: Array<string> = this.spNamess[spsName];
                            spNames || (this.spNamess[spsName] = spNames = []);
                            spNames.push(matchArr[2]);
                        }
                        console.log(this.spNamess);
                    });
                }, fail: res => {
                    console.error("loadSubpackage(" + "res" + ") fail" + JSON.stringify(res));
                }
            });
        });
        _btns.getChildByName("triggerGC").on(cc.Node.EventType.TOUCH_START, () => {
            wx?.triggerGC?.();
        });

        const _jpg2048s = _btns.getChildByName("jpg2048s");
        _jpg2048s.getChildByName("Texs").on(cc.Node.EventType.TOUCH_START, () => {
            this.loadTexs("2048x2048jpg");
        });
        _jpg2048s.getChildByName("SFs").on(cc.Node.EventType.TOUCH_START, () => {
            this.loadSFs("2048x2048jpg");
        });

        const _png2048s = _btns.getChildByName("png2048s");
        _png2048s.getChildByName("Texs").on(cc.Node.EventType.TOUCH_START, () => {
            this.loadTexs("2048x2048png");
        });
        _png2048s.getChildByName("SFs").on(cc.Node.EventType.TOUCH_START, () => {
            this.loadSFs("2048x2048png");
        });

        const _png2047s = _btns.getChildByName("png2047s");
        _png2047s.getChildByName("Texs").on(cc.Node.EventType.TOUCH_START, () => {
            this.loadTexs("2047x2047png");
        });
        _png2047s.getChildByName("SFs").on(cc.Node.EventType.TOUCH_START, () => {
            this.loadSFs("2047x2047png");
        });

        const _jpg1422s = _btns.getChildByName("jpg1422s");
        _jpg1422s.getChildByName("Texs").on(cc.Node.EventType.TOUCH_START, () => {
            this.loadTexs("1422x640jpg");
        });
        _jpg1422s.getChildByName("SFs").on(cc.Node.EventType.TOUCH_START, () => {
            this.loadSFs("1422x640jpg");
        });

        const _png1422s = _btns.getChildByName("png1422s");
        _png1422s.getChildByName("Texs").on(cc.Node.EventType.TOUCH_START, () => {
            this.loadTexs("1422x640png");
        });
        _png1422s.getChildByName("SFs").on(cc.Node.EventType.TOUCH_START, () => {
            this.loadSFs("1422x640png");
        });
    }

    private loadTexs(spsName: string): void {
        this.bundle.loadDir("Texture/" + spsName + "/", cc.Texture2D, (err, texs) => {
            console.log("loadTexs", spsName, texs.length);
        });
    }
    private loadSFs(spsName: string): void {
        this.bundle.loadDir("Texture/" + spsName + "/", cc.SpriteFrame, (err, sfs) => {
            console.log("loadSFs", spsName, sfs.length);
            const i = this.container.children.length;
            let x: number = i % w;
            let y: number = (i - x) / w;
            x--;
            for (const sf of sfs) {
                if (++x >= w) {
                    x = 0;
                    y++;
                }
                const node = new cc.Node();
                const sp = node.addComponent(cc.Sprite);
                sp.spriteFrame = sf;
                this.container.addChild(node);
                node.width = node.height = 22;
                node.x = x * d;
                node.y = -y * d;
            }
        });
    }

}
