
import { _decorator, Component, Node, find, Sprite, Material } from 'cc';
const { ccclass, property } = _decorator;

/**
 * Predefined variables
 * Name = NewComponent
 * DateTime = Thu Mar 03 2022 14:38:01 GMT+0800 (中国标准时间)
 * Author = Koei
 * FileBasename = NewComponent.ts
 * FileBasenameNoExtension = NewComponent
 * URL = db://assets/NewComponent.ts
 * ManualUrl = https://docs.cocos.com/creator/3.3/manual/zh/
 *
 */

@ccclass('NewComponent')
export class NewComponent extends Component {
    // [1]
    // dummy = '';

    // [2]
    // @property
    // serializableDummy = 0;
    mt: Material = null;
    time = 0;
    flag = false;
    start() {
        // [3]
        let spNode = find('Canvas/Sprite');
        let com = spNode.getComponent(Sprite);
        this.mt = com.getMaterial(0);
    }


    update(deltaTime: number) {
        if (this.time > 1) {
            this.flag = true;
        } else if (this.time <= 0) {
            this.flag = false;
        }
        if(this.flag){
            this.time -= deltaTime;
        }else{
            this.time += deltaTime;

        }
        // console.log(this.time)
        this.mt.setProperty('dissolveThreshold', this.time)
        //     // [4]
    }
}

/**
 * [1] Class member could be defined like this.
 * [2] Use `property` decorator if your want the member to be serializable.
 * [3] Your initialization goes here.
 * [4] Your update function goes here.
 *
 * Learn more about scripting: https://docs.cocos.com/creator/3.3/manual/zh/scripting/
 * Learn more about CCClass: https://docs.cocos.com/creator/3.3/manual/zh/scripting/ccclass.html
 * Learn more about life-cycle callbacks: https://docs.cocos.com/creator/3.3/manual/zh/scripting/life-cycle-callbacks.html
 */
