import { _decorator, Component, Node, Prefab, instantiate, UITransform } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('test')
export class test extends Component {
    @property(Prefab)
    a: Prefab = null;
    @property(Prefab)
    b: Prefab = null;
    @property(Node)
    root: Node = null;

    private _pool: { [name: string]: Node[] } = {};

    onLoad() {
        this._pool = {};
    }

    start() {
        this.schedule(this.createNode.bind(this), 1);
    }

    private createNode() {
        let self = this;
        for (let i = 0; i < 2400; ++i) {
            let name = Math.random() < 0.5 ? 'a' : 'b';
            let node = this.getItemByName(name);
            this.root.addChild(node);
            node.getComponent(UITransform).scheduleOnce(function () {
                self.putItemByName(name, node)
            }, 1)
        }
    }

    public getItemByName(resName: string) {
        let node: Node = null;
        if (this._pool[resName] == null || this._pool[resName].length <= 0) {
            node = instantiate(this[resName]);
        } else {
            node = this._pool[resName].pop();
        }
        return node;
    }

    public putItemByName(resName: string, node: Node) {
        if (this._pool[resName] == null) {
            this._pool[resName] = [];
        }
        node.removeFromParent();
        this._pool[resName].push(node);
    }

}


