const { ccclass, property } = cc._decorator;

@ccclass
export default class Helloworld extends cc.Component {

    @property(cc.Label)
    label: cc.Label = null;

    @property
    text: string = 'hello';

    list: cc.Node[] = [];

    bundleName = "resources";

    start() {
        // init logic
        this.label.string = this.text;

        cc.assetManager.loadBundle(this.bundleName, (error: Error, bundle: cc.AssetManager.Bundle) => {
            bundle.load("effect_lxy", (error: Error) => {

                this.scheduleOnce(this.onLoaded, 1);

                this.scheduleOnce(this.onNext, 5);
            });
        });
    }

    private onNext() {
        this.onLoaded(40);
    }

    private onLoaded(offset: number = 0) {
        console.log("onLoaded");

        this.list.forEach((node) => {
            node.removeAllChildren();
            node.destroy();
            node = null;
        })
        this.list.length = 0;

        let bundle = cc.assetManager.getBundle(this.bundleName);
        for (let i = 0; i < 10; i++) {
            let prefab: cc.Prefab = bundle.get("effect_lxy", cc.Prefab);
            let node = cc.instantiate(prefab);
            node.parent = this.node;
            node.y = Math.floor(i / 5) * 300 - 150 + offset;
            node.x = (i % 5) * 250 - 500;
            this.list.push(node);
        }
    }

}
