import { _decorator, Component, Node, game } from "cc";
const { ccclass, property } = _decorator;

/**
 * Predefined variables
 * Name = Test
 * DateTime = Mon Nov 29 2021 11:31:55 GMT+0800 (中国标准时间)
 * Author = gaolizheng
 * FileBasename = Test.ts
 * FileBasenameNoExtension = Test
 * URL = db://assets/Scripts/Test.ts
 * ManualUrl = https://docs.cocos.com/creator/3.3/manual/zh/
 *
 */

@ccclass("Test")
export class Test extends Component {
  @property({ type: Node })
  layer1Node: Node = null;
  @property({ type: Node })
  layer3Node: Node = null;

  @property({ type: Node })
  btn1to3: Node = null;
  @property({ type: Node })
  btn3to1: Node = null;

  start() {
    this.btn1to3.on(Node.EventType.TOUCH_START, () => {
      console.log("changeLayer1ToLayer3");
      this.layer1Node.layer = 1 << 3;
    });
    this.btn3to1.on(Node.EventType.TOUCH_START, () => {
      console.log("changeLayer3ToLayer1");
      this.layer1Node.layer = 1 << 1;
    });
  }
}
