import Point from "./Point";

const { ccclass, property } = cc._decorator;

@ccclass
export default class Cloth extends cc.Component {

    private graphics: cc.Graphics = null;
    private canvas: cc.Node = null;

    private points: Point[] = [];
    private cloth_width: number = 49;
    private cloth_height: number = 29;
    private mouse: { down: boolean, button: number, x: number, y: number, px: number, py: number } = { down: false, button: 1, x: 0, y: 0, px: 0, py: 0 };

    protected onLoad() {
        this.graphics = this.getComponent(cc.Graphics);
        this.canvas = cc.Canvas.instance.node;
        this.addEvent();
    }

    start() {
        for (let y = 0; y <= this.cloth_height; y++) {
            let pre_point: Point = null;
            for (let x = 0; x <= this.cloth_width; x++) {
                let p = new Point(10 * x, -10 * y, this.mouse);
                if (x !== 0 && pre_point) {
                    p.attach(pre_point)
                }
                if (y === 0) {//第一排
                    p.pin(p.x, p.y);
                } else {
                    //链接上一排的点
                    p.attach(this.points[x + (y - 1) * (this.cloth_width + 1)])
                }
                pre_point = p;
                this.points.push(p);
            }
        }

        this.schedule(this.OnFrame);
    }

    protected OnFrame(): void {
        this.updateInfo();
        this.draw();
    }

    updateInfo(): void {
        let len = 0;
        let physics_accuracy = 3;

        // for (let i = 0; i < physics_accuracy; i++) {
        len = this.points.length;
        for (let j = len - 1; j > 0; j--) {
            this.points[j].resolve_constraints();
        }
        // }

        len = this.points.length;
        for (let j = len - 1; j > 0; j--) {
            this.points[j].update(.016);
        }
    }

    public draw(): void {
        this.graphics.clear();

        let len = this.points.length - 1;
        for (let i = len; i > 0; i--) {
            this.points[i].draw(this.graphics);
            this.graphics.stroke();
        }
    }

    protected addEvent(): void {
        this.canvas.on(cc.Node.EventType.MOUSE_DOWN, this.MouseDown, this);
    }

    protected MouseDown(e: cc.Event.EventMouse): void {

        this.mouse.down = true;
        let pos: cc.Vec2 = e.getLocation();

        this.node.convertToNodeSpaceAR(pos, pos);

        this.mouse.x = pos.x, this.mouse.y = pos.y;

        console.log(pos.x, pos.y);

        this.canvas.on(cc.Node.EventType.MOUSE_UP, this.OnMouseUp, this);
        this.canvas.on(cc.Node.EventType.MOUSE_LEAVE, this.OnMouseUp, this);
        this.canvas.on(cc.Node.EventType.MOUSE_MOVE, this.OnMouseMove, this);
    }

    protected OnMouseUp(e: any): void {

        this.mouse.down = false;

        this.canvas.off(cc.Node.EventType.MOUSE_UP, this.OnMouseUp, this);
        this.canvas.off(cc.Node.EventType.MOUSE_LEAVE, this.OnMouseUp, this);
        this.canvas.off(cc.Node.EventType.MOUSE_MOVE, this.OnMouseMove, this);
    }

    protected OnMouseMove(e: cc.Event.EventMouse): void {
        this.mouse.px = e.getDeltaX();
        this.mouse.py = e.getDeltaY();
    }
}
