
export default class Point {

    private mouse: { down: boolean, button: number, x: number, y: number, px: number, py: number };

    public x: number;
    public y: number;

    private px: number;
    private py: number;

    protected vx: number = 0;
    protected vy: number = 0;

    protected pin_x: number = null;
    protected pin_y: number = null;


    /**间距 */
    private spaing = 10;
    //撕裂距离
    private tear_distance: number = 60;
    //鼠标影响范围
    private mouse_influence: number = 20;

    private gravity: number = -980;

    private constraints: Point[] = [];

    constructor(x: number, y: number, mouse: any) {
        this.px = this.x = x;
        this.py = this.y = y;
        this.mouse = mouse;
    }

    public attach(point: Point) {
        this.constraints.push(point);
    }

    public pin(x: number, y: number) {
        this.pin_x = x;
        this.pin_y = y;
    }

    /**重力？ */
    protected add_force(x: number, y: number) {
        this.vx += x;
        this.vy += y;
    }

    public update(delta: number): void {
        if (this.mouse.down) {
            let dif_x = this.x - this.mouse.x,
                dif_y = this.y - this.mouse.y,
                dis = Math.sqrt(Math.pow(dif_x, 2) + Math.pow(dif_y, 2));

            if (dis < this.mouse_influence) {
                this.px = this.x - this.mouse.px * 1.8;
                this.py = this.y - this.mouse.py * 1.8;
            }
        }

        this.add_force(0, this.gravity);

        delta *= delta;
        let nx = this.x + ((this.x - this.px) * .99) + ((this.vx / 2) * delta);
        let ny = this.y + ((this.y - this.py) * .99) + ((this.vy / 2) * delta);

        this.px = this.x;
        this.py = this.y;

        this.x = nx;
        this.y = ny;

        this.vy = this.vx = 0
    }

    public draw(ctx: cc.Graphics): void {
        let len = this.constraints.length;
        if (len <= 0) return;

        for (let i = 0; i < len; i++) {
            let p = this.constraints[i];
            ctx.moveTo(this.x, this.y);
            ctx.lineTo(p.x, p.y);
        }
    }

    public resolve_constraints(): void {
        if (this.pin_x != null && this.pin_y != null) {
            this.x = this.pin_x;
            this.y = this.pin_y;
            return;
        }

        for (let i = 0; i < this.constraints.length; i++) {
            let resolve = this.resolve(i);
            if (resolve) {
                this.constraints.splice(i, 1);
                i--;
            }
        }

    }

    public resolve(idx: number): boolean {
        let p: Point = this.constraints[idx];
        let dis_x = this.x - p.x,
            dis_y = this.y - p.y,
            dist = Math.sqrt(Math.pow(dis_x, 2) + Math.pow(dis_y, 2)),
            diff = (this.spaing - dist) / dist;

        if (dist > this.tear_distance) {//线断了
            return true;
        }

        let px = dis_x * diff * .5;
        let py = dis_y * diff * .5;

        this.x += px;
        this.y += py;

        p.x -= px;
        p.y -= py;

        return false;
    }
}