cc.Class({
    extends: cc.Component,

    properties: {
        label: {
            default: null,
            type: cc.Label
        },
        text: 'Hello, World!',
        tex: cc.Texture2D,
        rtNode: cc.Node
    },

    // use this for initialization
    onLoad: function () {
        this.label.string = this.text;
    },

    start: function () {
        this.rt = new cc.RenderTexture();
        this.rt.initWithSize(cc.winSize.width, cc.winSize.height);  
        // this.rtNode.getComponent(cc.Sprite).spriteFrame.setTexture(this.rt);
        //
        this.node.on(cc.Node.EventType.TOUCH_MOVE, this._touchMoveCallback, this);
    },

    _touchMoveCallback (event) {
        var touches = event.getTouches();
        var touchLoc = touches[0].getLocation();
        this.rt.drawTextureAt(this.tex, touchLoc.x, 0);
        this.rtNode.getComponent(cc.Sprite).spriteFrame.setTexture(this.rt);
    },
});
