
import { _decorator, Component, Node, Collider, Vec3 } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('BallComponent')
export class BallComponent extends Component {


    start() {
        const collider = this.node.getComponent(Collider)
        collider.on("onTriggerEnter", this.onTrigger, this)
    }

    onTrigger() {
        console.warn("onTrigger");
    }

    update(deltaTime: number) {
        const position = this.node.getWorldPosition()
        this.node.setWorldPosition(position.add(new Vec3(0, 0, -0.1)))
    }
}

