import { _decorator, Collider2D, Component, Contact2DType, director, EventTouch, Input, IPhysics2DContact, Label, MotionStreak, Node, ParticleSystem2D, PhysicsSystem2D, RigidBody2D, sp, Sprite, SpriteFrame, sys, tween, UIOpacity, UITransform, v2, v3, Vec2, Vec3 } from 'cc';

const { ccclass, property } = _decorator;

@ccclass('Nezha')
export class Nezha extends Component {

    @property(Node)
    player: Node = null;

    @property(RigidBody2D)
    ball: RigidBody2D = null;

    @property(Node)
    leftBtn: Node = null;
    @property(Node)
    rightBtn: Node = null;
    @property(Node)
    left: Node = null;
    @property(Node)
    right: Node = null;

    @property(Label)
    scoreLb: Label = null;

    @property(Label)
    bestScoreLb: Label = null;

    @property(Node)
    beginNode: Node = null;

    isTi: boolean = false;

    score: number = 0;

    bestScore: number = 0;

    isBeginGame: boolean = false;

    jianZiOriginY: number = 0;

    tiAniOk: boolean = true;

    isQianTi: boolean = false;

    nezhaScaleX: number = 0;

    currDir: string = '';

    mTiTimer = null;

    /**当前力气等级 */
    currLiLv: number = 0;

    protected onLoad(): void {
        const system = PhysicsSystem2D.instance;
        system.gravity = (new Vec2(0, -1500));
        system.fixedTimeStep = 1 / 60;
        system.velocityIterations = 10;
        system.positionIterations = 10;
        this.jianZiOriginY = this.ball.node.position.y;

        this.nezhaScaleX = this.player.scale.x;

        if (PhysicsSystem2D.instance) {
            PhysicsSystem2D.instance.on(Contact2DType.BEGIN_CONTACT, this.onBeginContact, this);
        }

        this.leftBtn.on(Input.EventType.TOUCH_START, this.leftTiEventFc, this);
        this.rightBtn.on(Input.EventType.TOUCH_START, this.rightTiEventFc, this);
    }

    removeTiTimer() {
        if (this.mTiTimer != null) {
            this.unschedule(this.mTiTimer);
            this.mTiTimer = null;
        }
    }

    /**监视落地 */
    onBeginContact(selfCollider: Collider2D, otherCollider: Collider2D, contact: IPhysics2DContact | null) {
        // 只在两个碰撞体开始接触时被调用一次
        if (this.isTi || !this.isBeginGame) return;
        this.isBeginGame = false;
        this.beginNode.active = true;
        this.tiAniOk = true;
        this.removeTiTimer();
        this.resetScore();
        this.isZiDongTi = false;

        this.currTiNum = 0;

        if (this.isZiDong) {
            this.scheduleOnce(() => {
                if (!this.isZiDong) return;
                this.beginBtn()
            }, 2)
        }

        // this.nezhaSp.skeletonData = this.nezhaStaysp;
        // this.nezhaSp.clearTracks();
        // this.nezhaSp.setAnimation(0, "stay", true);
    }

    beginBtn(e?: EventTouch) {
        if (e && this.isZiDong) return;
        this.isBeginGame = true;
        this.beginNode.active = false;
        if (this.isZiDong) {
            this.scheduleOnce(() => {
                if (!this.isZiDong) return;
                this.isZiDongTi = true;
            }, 3)
        }
    }

    leftTiEventFc(e?: EventTouch) {
        this.ti();
    }

    rightTiEventFc(e?: EventTouch) {
        this.ti();
    }

    getWorldPos(dir: string) {
        let worldPos: Vec3 = v3();
        if (dir == "l") {
            worldPos = this.left.getComponent(UITransform).convertToWorldSpaceAR(v3(0, 0, 0));
        } else {
            worldPos = this.right.getComponent(UITransform).convertToWorldSpaceAR(v3(0, 0, 0));
        }
        let x = worldPos.x;
        let y = worldPos.y;
        let random1 = Math.random() * 100;
        random1 > 50 ? x += 30 : x -= 30;
        let random2 = Math.random() * 100;
        random2 > 50 ? y += 20 : y -= 20;
        return v3(x, y, 0);
    }

    ti() {
        this.isQianTi = !this.isQianTi;
        this.tiAniOk = false;

        this.player.active = true;

        if (this.mTiTimer == null) {
            this.mTiTimer = this.tiBtn.bind(this, this.currDir);
            this.scheduleOnce(this.mTiTimer, 1 / 30);
        }
        this.currTiNum += 1;

        // this.nezhaSp.setTrackEventListener(t, (ep, event: sp.spine.Event) => {
        //     if (event.data.name === "ti") {
        //         // console.log('监听帧事件---------------')
        //         this.tiBtn(arg);
        //     }
        // });
    }

    /**踢 */
    tiBtn(arg: string) {
        this.removeTiTimer();

        if (arg == "l") {
            this.player.setScale(-this.nezhaScaleX, this.nezhaScaleX, this.nezhaScaleX);
        } else {
            this.player.setScale(this.nezhaScaleX, this.nezhaScaleX, this.nezhaScaleX);
        }


        this.isTi = true;
        let randomLi: number = 0;
        let rNum = Math.random();
        if (rNum > 0.9) {
            randomLi = 40 + Math.random() * 10;
            this.currLiLv = 1;
        }
        else if (rNum > 0.8) {
            randomLi = 30 + Math.random() * 10;
            this.currLiLv = 2;
        } else {
            randomLi = 20 + Math.random() * 10;
            this.currLiLv = 3;
        }

        let xTweenTime: number = 0;
        let angleTime: number = 0;
        xTweenTime = 0.3 * (randomLi - 20) / 30 + 0.3;
        angleTime = 0.3 * (randomLi - 20) / 30 + 0.2;
        this.ball.linearVelocity = v2(0, randomLi);

        this.setBallAngleTween(angleTime);
        let random = Math.random() * 100;
        if (random > 80) {
            this.setBallXTween(xTweenTime);
        }

        this.addScore(1);
    }

    /**设置毽子旋转缓动 */
    setBallAngleTween(time: number = 0.5) {
        let x = this.ball.node.position.x
        let isRight = x > 0 ? true : false;
        tween({ angle: 0 })
            .set({ angle: 0 })
            .to(time, { angle: isRight ? 180 : -180 }, {
                onUpdate: ({ angle }) => {
                    this.ball.node.angle = angle;
                }
            })
            .call(() => {
                this.isTi = false;
            })
            .to(time + 0.2, { angle: isRight ? 360 : -360 }, {
                onUpdate: ({ angle }) => {
                    this.ball.node.angle = angle;
                }
            })
            .start()
    }

    /**设置毽子x轴的位移缓动 */
    setBallXTween(time: number = 0.5) {
        let toX = this.ball.node.position.x > 0 ? -65 : 65;
        tween({ p: -toX })
            .to(time, { p: 0, }, {
                onUpdate: ({ p }) => {
                    this.ball.node.setPosition(v3(p, this.ball.node.position.y, 0))
                }
            })
            .call(() => {
                this.player.setScale(-this.player.scale.x, this.nezhaScaleX, this.nezhaScaleX);
            })
            .to(time, { p: toX }, {
                onUpdate: ({ p }) => {
                    this.ball.node.setPosition(v3(p, this.ball.node.position.y, 0))
                }
            })
            .start();
    }

    /**判断是否能踢 */
    isCanTi(y: number) {

        return true

    }

    /**判断方向是否相同 */
    dirIsSame(dir: string) {
        let x = this.ball.node.position.x;
        if ((x > 0 && dir == "r") || (x < 0 && dir == "l")) {
            return true;
        }

        return false;
    }

    resetScore() {
        this.score = 0;
        this.scoreLb.string = `${this.score}`;

    }

    addScore(addScore: number) {
        this.score += addScore;
        this.scoreLb.string = `${this.score}`;
        tween(this.scoreLb.node)
            .to(0.2, { scale: v3(1.5, 1.5, 1.5) })
            .to(0.3, { scale: v3(1, 1, 1) })
            .start();
    }

    close() {
        if (PhysicsSystem2D.instance) {
            PhysicsSystem2D.instance.off(Contact2DType.BEGIN_CONTACT, this.onBeginContact, this);
        }

        this.leftBtn.off(Input.EventType.TOUCH_START, this.leftTiEventFc, this);
        this.rightBtn.off(Input.EventType.TOUCH_START, this.rightTiEventFc, this);
        director.loadScene("HurryScene");
        // this.ctl.openMainView();
    }

    clickHuangGuanNum: number = 0;

    isZiDong: boolean = false;

    isZiDongTi: boolean = false;

    isCanTiNum: number = 0;

    currTiNum: number = 0;

    clearClickHuangGuanNum() {
        this.clickHuangGuanNum = 0;
    }

    protected update(dt: number): void {
        if (!this.isZiDong || !this.isZiDongTi) return;

        let x = this.ball.node.position.x;

        let checkY: number = 0;
        if (this.currTiNum >= this.isCanTiNum) {
            checkY = -180;
        } else {
            if (this.currLiLv == 1) {
                checkY = -100;
            } else if (this.currLiLv == 2) {
                checkY = -120;
            } else if (this.currLiLv == 3) {
                checkY = -140;
            }
        }

        // console.log('checkY--------------', checkY, this.currTiNum, this.isCanTiNum)

        if (this.ball.node.position.y <= checkY) {
            x >= 0 ? this.rightTiEventFc() : this.leftTiEventFc();
        }
    }
}


