// 每个node点基于Canvas的坐标。本身canvas的position就必须有。
// 主要是因为他的中心点是375*667.本次设定的是iphone6的基准屏幕，750*1334，
// 所以在计算世界坐标的时候要考虑进去
//这个js挂在map上，map以上的层级锚点都是0.0，否则会出现对不准的情况，锚点0.0的目的是好计算。
//这个层级结构
// canvas
//  -Main Camera
//  -Bg
//      --map
//      --player
// 其中bg左下角对齐，bg和map的锚点是0.0  本次大小设定的是2000*2000，否则触摸不上去，这个Js挂在
cc.Class({
    extends: cc.Component,

    properties: {

        player: cc.Node,//对应player
        mainCameraNode:cc.Node,//对应Main Camera

    },

    // LIFE-CYCLE CALLBACKS:

    onLoad() {
        this.node.on(cc.Node.EventType.TOUCH_START, this._onTouchStartCallback, this);
        this.node.on(cc.Node.EventType.TOUCH_MOVE, this._onTouchMoveCallback, this);
        this.node.on(cc.Node.EventType.TOUCH_CANCEL, this._onTouchCancelCallback, this);
        this.node.on(cc.Node.EventType.TOUCH_END, this._onTouchEndCallback, this);

    },

    start() {
        this.cameraParentPos=this.mainCameraNode.parent.position;
    },
    _onTouchStartCallback(event) {

    },
    _onTouchMoveCallback(event) {

    },
    _onTouchCancelCallback(event) {

    },
    _onTouchEndCallback(event) {
        var pos = event.touch.getLocation();
        //触摸点屏幕坐标
        cc.log('pos',pos.x,pos.y)
        // let worldPos2 = this.node.convertToWorldSpaceAR(pos);
        // //得到的结果是触摸点的世界坐标
        // cc.log('worldPos2',worldPos2.x,worldPos2.y)
        //因为bg是在canvas上的，而canvas调整成屏幕大小是有大小的，他的基准点就是屏幕大小的中心。
        //而屏幕坐标的基准点是屏幕的左下角开始的，所以要减去这个差值


        var cameraPos=this.mainCameraNode.position;//这个是相机的坐标
        cc.log('cameraPos',cameraPos.x,cameraPos.y)
        var temp = pos.add(cameraPos);//触摸点的世界坐标
        cc.log('temp',temp.x,temp.y);
        //触摸点的世界坐标减去现在player的世界坐标
        var disPos=temp.sub(this.player.position)
        var dis = Math.abs(disPos.mag())  // 两个点之间的距离,
        var v = 300;                    // 移动速度
        var speed=dis / v

        cc.Tween.stopAllByTarget(this.player);// 防止乱跑
        cc.tween(this.player)
            .call(() => {
                console.log("移动前的准备")
            })
            .to((speed), { position: temp })
            .call(() => {
                console.log("移动完成！")
            })
            .start()
    },
    update (dt) {
        //玩家坐标-相机父节点canvas的坐标，得到相机中心点的相对坐标
        let cameraPos=this.player.position.sub(this.cameraParentPos)
        //不超墙，
        this.mainCameraNode.setPosition(cameraPos)
    },
});


