
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/script/payerRun.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '911b6iEiUFBSo+6vmwA6GB2', 'payerRun');
// script/payerRun.js

"use strict";

// 每个node点基于Canvas的坐标。本身canvas的position就必须有。
// 主要是因为他的中心点是375*667.本次设定的是iphone6的基准屏幕，750*1334，
// 所以在计算世界坐标的时候要考虑进去
//这个js挂在map上，map以上的层级锚点都是0.0，否则会出现对不准的情况，锚点0.0的目的是好计算。
//这个层级结构
// canvas
//  -Main Camera
//  -Bg
//      --map
//      --player
// 其中bg左下角对齐，bg和map的锚点是0.0  本次大小设定的是2000*2000，否则触摸不上去，这个Js挂在
cc.Class({
  "extends": cc.Component,
  properties: {
    player: cc.Node,
    //对应player
    mainCameraNode: cc.Node //对应Main Camera

  },
  // LIFE-CYCLE CALLBACKS:
  onLoad: function onLoad() {
    this.node.on(cc.Node.EventType.TOUCH_START, this._onTouchStartCallback, this);
    this.node.on(cc.Node.EventType.TOUCH_MOVE, this._onTouchMoveCallback, this);
    this.node.on(cc.Node.EventType.TOUCH_CANCEL, this._onTouchCancelCallback, this);
    this.node.on(cc.Node.EventType.TOUCH_END, this._onTouchEndCallback, this);
  },
  start: function start() {
    this.cameraParentPos = this.mainCameraNode.parent.position;
  },
  _onTouchStartCallback: function _onTouchStartCallback(event) {},
  _onTouchMoveCallback: function _onTouchMoveCallback(event) {},
  _onTouchCancelCallback: function _onTouchCancelCallback(event) {},
  _onTouchEndCallback: function _onTouchEndCallback(event) {
    var pos = event.touch.getLocation(); //触摸点屏幕坐标

    cc.log('pos', pos.x, pos.y); // let worldPos2 = this.node.convertToWorldSpaceAR(pos);
    // //得到的结果是触摸点的世界坐标
    // cc.log('worldPos2',worldPos2.x,worldPos2.y)
    //因为bg是在canvas上的，而canvas调整成屏幕大小是有大小的，他的基准点就是屏幕大小的中心。
    //而屏幕坐标的基准点是屏幕的左下角开始的，所以要减去这个差值

    var cameraPos = this.mainCameraNode.position; //这个是相机的坐标

    cc.log('cameraPos', cameraPos.x, cameraPos.y);
    var temp = pos.add(cameraPos); //触摸点的世界坐标

    cc.log('temp', temp.x, temp.y); //触摸点的世界坐标减去现在player的世界坐标

    var disPos = temp.sub(this.player.position);
    var dis = Math.abs(disPos.mag()); // 两个点之间的距离,

    var v = 300; // 移动速度

    var speed = dis / v;
    cc.Tween.stopAllByTarget(this.player); // 防止乱跑

    cc.tween(this.player).call(function () {
      console.log("移动前的准备");
    }).to(speed, {
      position: temp
    }).call(function () {
      console.log("移动完成！");
    }).start();
  },
  update: function update(dt) {
    //玩家坐标-相机父节点canvas的坐标，得到相机中心点的相对坐标
    var cameraPos = this.player.position.sub(this.cameraParentPos); //不超墙，

    this.mainCameraNode.setPosition(cameraPos);
  }
});

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImFzc2V0c1xcc2NyaXB0XFxwYXllclJ1bi5qcyJdLCJuYW1lcyI6WyJjYyIsIkNsYXNzIiwiQ29tcG9uZW50IiwicHJvcGVydGllcyIsInBsYXllciIsIk5vZGUiLCJtYWluQ2FtZXJhTm9kZSIsIm9uTG9hZCIsIm5vZGUiLCJvbiIsIkV2ZW50VHlwZSIsIlRPVUNIX1NUQVJUIiwiX29uVG91Y2hTdGFydENhbGxiYWNrIiwiVE9VQ0hfTU9WRSIsIl9vblRvdWNoTW92ZUNhbGxiYWNrIiwiVE9VQ0hfQ0FOQ0VMIiwiX29uVG91Y2hDYW5jZWxDYWxsYmFjayIsIlRPVUNIX0VORCIsIl9vblRvdWNoRW5kQ2FsbGJhY2siLCJzdGFydCIsImNhbWVyYVBhcmVudFBvcyIsInBhcmVudCIsInBvc2l0aW9uIiwiZXZlbnQiLCJwb3MiLCJ0b3VjaCIsImdldExvY2F0aW9uIiwibG9nIiwieCIsInkiLCJjYW1lcmFQb3MiLCJ0ZW1wIiwiYWRkIiwiZGlzUG9zIiwic3ViIiwiZGlzIiwiTWF0aCIsImFicyIsIm1hZyIsInYiLCJzcGVlZCIsIlR3ZWVuIiwic3RvcEFsbEJ5VGFyZ2V0IiwidHdlZW4iLCJjYWxsIiwiY29uc29sZSIsInRvIiwidXBkYXRlIiwiZHQiLCJzZXRQb3NpdGlvbiJdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7Ozs7Ozs7Ozs7QUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0FBLEVBQUUsQ0FBQ0MsS0FBSCxDQUFTO0FBQ0wsYUFBU0QsRUFBRSxDQUFDRSxTQURQO0FBR0xDLEVBQUFBLFVBQVUsRUFBRTtBQUVSQyxJQUFBQSxNQUFNLEVBQUVKLEVBQUUsQ0FBQ0ssSUFGSDtBQUVRO0FBQ2hCQyxJQUFBQSxjQUFjLEVBQUNOLEVBQUUsQ0FBQ0ssSUFIVixDQUdlOztBQUhmLEdBSFA7QUFVTDtBQUVBRSxFQUFBQSxNQVpLLG9CQVlJO0FBQ0wsU0FBS0MsSUFBTCxDQUFVQyxFQUFWLENBQWFULEVBQUUsQ0FBQ0ssSUFBSCxDQUFRSyxTQUFSLENBQWtCQyxXQUEvQixFQUE0QyxLQUFLQyxxQkFBakQsRUFBd0UsSUFBeEU7QUFDQSxTQUFLSixJQUFMLENBQVVDLEVBQVYsQ0FBYVQsRUFBRSxDQUFDSyxJQUFILENBQVFLLFNBQVIsQ0FBa0JHLFVBQS9CLEVBQTJDLEtBQUtDLG9CQUFoRCxFQUFzRSxJQUF0RTtBQUNBLFNBQUtOLElBQUwsQ0FBVUMsRUFBVixDQUFhVCxFQUFFLENBQUNLLElBQUgsQ0FBUUssU0FBUixDQUFrQkssWUFBL0IsRUFBNkMsS0FBS0Msc0JBQWxELEVBQTBFLElBQTFFO0FBQ0EsU0FBS1IsSUFBTCxDQUFVQyxFQUFWLENBQWFULEVBQUUsQ0FBQ0ssSUFBSCxDQUFRSyxTQUFSLENBQWtCTyxTQUEvQixFQUEwQyxLQUFLQyxtQkFBL0MsRUFBb0UsSUFBcEU7QUFFSCxHQWxCSTtBQW9CTEMsRUFBQUEsS0FwQkssbUJBb0JHO0FBQ0osU0FBS0MsZUFBTCxHQUFxQixLQUFLZCxjQUFMLENBQW9CZSxNQUFwQixDQUEyQkMsUUFBaEQ7QUFDSCxHQXRCSTtBQXVCTFYsRUFBQUEscUJBdkJLLGlDQXVCaUJXLEtBdkJqQixFQXVCd0IsQ0FFNUIsQ0F6Qkk7QUEwQkxULEVBQUFBLG9CQTFCSyxnQ0EwQmdCUyxLQTFCaEIsRUEwQnVCLENBRTNCLENBNUJJO0FBNkJMUCxFQUFBQSxzQkE3Qkssa0NBNkJrQk8sS0E3QmxCLEVBNkJ5QixDQUU3QixDQS9CSTtBQWdDTEwsRUFBQUEsbUJBaENLLCtCQWdDZUssS0FoQ2YsRUFnQ3NCO0FBQ3ZCLFFBQUlDLEdBQUcsR0FBR0QsS0FBSyxDQUFDRSxLQUFOLENBQVlDLFdBQVosRUFBVixDQUR1QixDQUV2Qjs7QUFDQTFCLElBQUFBLEVBQUUsQ0FBQzJCLEdBQUgsQ0FBTyxLQUFQLEVBQWFILEdBQUcsQ0FBQ0ksQ0FBakIsRUFBbUJKLEdBQUcsQ0FBQ0ssQ0FBdkIsRUFIdUIsQ0FJdkI7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFHQSxRQUFJQyxTQUFTLEdBQUMsS0FBS3hCLGNBQUwsQ0FBb0JnQixRQUFsQyxDQVh1QixDQVdvQjs7QUFDM0N0QixJQUFBQSxFQUFFLENBQUMyQixHQUFILENBQU8sV0FBUCxFQUFtQkcsU0FBUyxDQUFDRixDQUE3QixFQUErQkUsU0FBUyxDQUFDRCxDQUF6QztBQUNBLFFBQUlFLElBQUksR0FBR1AsR0FBRyxDQUFDUSxHQUFKLENBQVFGLFNBQVIsQ0FBWCxDQWJ1QixDQWFPOztBQUM5QjlCLElBQUFBLEVBQUUsQ0FBQzJCLEdBQUgsQ0FBTyxNQUFQLEVBQWNJLElBQUksQ0FBQ0gsQ0FBbkIsRUFBcUJHLElBQUksQ0FBQ0YsQ0FBMUIsRUFkdUIsQ0FldkI7O0FBQ0EsUUFBSUksTUFBTSxHQUFDRixJQUFJLENBQUNHLEdBQUwsQ0FBUyxLQUFLOUIsTUFBTCxDQUFZa0IsUUFBckIsQ0FBWDtBQUNBLFFBQUlhLEdBQUcsR0FBR0MsSUFBSSxDQUFDQyxHQUFMLENBQVNKLE1BQU0sQ0FBQ0ssR0FBUCxFQUFULENBQVYsQ0FqQnVCLENBaUJXOztBQUNsQyxRQUFJQyxDQUFDLEdBQUcsR0FBUixDQWxCdUIsQ0FrQlM7O0FBQ2hDLFFBQUlDLEtBQUssR0FBQ0wsR0FBRyxHQUFHSSxDQUFoQjtBQUVBdkMsSUFBQUEsRUFBRSxDQUFDeUMsS0FBSCxDQUFTQyxlQUFULENBQXlCLEtBQUt0QyxNQUE5QixFQXJCdUIsQ0FxQmU7O0FBQ3RDSixJQUFBQSxFQUFFLENBQUMyQyxLQUFILENBQVMsS0FBS3ZDLE1BQWQsRUFDS3dDLElBREwsQ0FDVSxZQUFNO0FBQ1JDLE1BQUFBLE9BQU8sQ0FBQ2xCLEdBQVIsQ0FBWSxRQUFaO0FBQ0gsS0FITCxFQUlLbUIsRUFKTCxDQUlTTixLQUpULEVBSWlCO0FBQUVsQixNQUFBQSxRQUFRLEVBQUVTO0FBQVosS0FKakIsRUFLS2EsSUFMTCxDQUtVLFlBQU07QUFDUkMsTUFBQUEsT0FBTyxDQUFDbEIsR0FBUixDQUFZLE9BQVo7QUFDSCxLQVBMLEVBUUtSLEtBUkw7QUFTSCxHQS9ESTtBQWdFTDRCLEVBQUFBLE1BaEVLLGtCQWdFR0MsRUFoRUgsRUFnRU87QUFDUjtBQUNBLFFBQUlsQixTQUFTLEdBQUMsS0FBSzFCLE1BQUwsQ0FBWWtCLFFBQVosQ0FBcUJZLEdBQXJCLENBQXlCLEtBQUtkLGVBQTlCLENBQWQsQ0FGUSxDQUdSOztBQUNBLFNBQUtkLGNBQUwsQ0FBb0IyQyxXQUFwQixDQUFnQ25CLFNBQWhDO0FBQ0g7QUFyRUksQ0FBVCIsInNvdXJjZVJvb3QiOiIvIiwic291cmNlc0NvbnRlbnQiOlsiLy8g5q+P5Liqbm9kZeeCueWfuuS6jkNhbnZhc+eahOWdkOagh+OAguacrOi6q2NhbnZhc+eahHBvc2l0aW9u5bCx5b+F6aG75pyJ44CCXHJcbi8vIOS4u+imgeaYr+WboOS4uuS7lueahOS4reW/g+eCueaYrzM3NSo2Njcu5pys5qyh6K6+5a6a55qE5pivaXBob25lNueahOWfuuWHhuWxj+W5le+8jDc1MCoxMzM077yMXHJcbi8vIOaJgOS7peWcqOiuoeeul+S4lueVjOWdkOagh+eahOaXtuWAmeimgeiAg+iZkei/m+WOu1xyXG4vL+i/meS4qmpz5oyC5ZyobWFw5LiK77yMbWFw5Lul5LiK55qE5bGC57qn6ZSa54K56YO95pivMC4w77yM5ZCm5YiZ5Lya5Ye6546w5a+55LiN5YeG55qE5oOF5Ya177yM6ZSa54K5MC4w55qE55uu55qE5piv5aW96K6h566X44CCXHJcbi8v6L+Z5Liq5bGC57qn57uT5p6EXHJcbi8vIGNhbnZhc1xyXG4vLyAgLU1haW4gQ2FtZXJhXHJcbi8vICAtQmdcclxuLy8gICAgICAtLW1hcFxyXG4vLyAgICAgIC0tcGxheWVyXHJcbi8vIOWFtuS4rWJn5bem5LiL6KeS5a+56b2Q77yMYmflkoxtYXDnmoTplJrngrnmmK8wLjAgIOacrOasoeWkp+Wwj+iuvuWumueahOaYrzIwMDAqMjAwMO+8jOWQpuWImeinpuaRuOS4jeS4iuWOu++8jOi/meS4qkpz5oyC5ZyoXHJcbmNjLkNsYXNzKHtcclxuICAgIGV4dGVuZHM6IGNjLkNvbXBvbmVudCxcclxuXHJcbiAgICBwcm9wZXJ0aWVzOiB7XHJcblxyXG4gICAgICAgIHBsYXllcjogY2MuTm9kZSwvL+WvueW6lHBsYXllclxyXG4gICAgICAgIG1haW5DYW1lcmFOb2RlOmNjLk5vZGUsLy/lr7nlupRNYWluIENhbWVyYVxyXG5cclxuICAgIH0sXHJcblxyXG4gICAgLy8gTElGRS1DWUNMRSBDQUxMQkFDS1M6XHJcblxyXG4gICAgb25Mb2FkKCkge1xyXG4gICAgICAgIHRoaXMubm9kZS5vbihjYy5Ob2RlLkV2ZW50VHlwZS5UT1VDSF9TVEFSVCwgdGhpcy5fb25Ub3VjaFN0YXJ0Q2FsbGJhY2ssIHRoaXMpO1xyXG4gICAgICAgIHRoaXMubm9kZS5vbihjYy5Ob2RlLkV2ZW50VHlwZS5UT1VDSF9NT1ZFLCB0aGlzLl9vblRvdWNoTW92ZUNhbGxiYWNrLCB0aGlzKTtcclxuICAgICAgICB0aGlzLm5vZGUub24oY2MuTm9kZS5FdmVudFR5cGUuVE9VQ0hfQ0FOQ0VMLCB0aGlzLl9vblRvdWNoQ2FuY2VsQ2FsbGJhY2ssIHRoaXMpO1xyXG4gICAgICAgIHRoaXMubm9kZS5vbihjYy5Ob2RlLkV2ZW50VHlwZS5UT1VDSF9FTkQsIHRoaXMuX29uVG91Y2hFbmRDYWxsYmFjaywgdGhpcyk7XHJcblxyXG4gICAgfSxcclxuXHJcbiAgICBzdGFydCgpIHtcclxuICAgICAgICB0aGlzLmNhbWVyYVBhcmVudFBvcz10aGlzLm1haW5DYW1lcmFOb2RlLnBhcmVudC5wb3NpdGlvbjtcclxuICAgIH0sXHJcbiAgICBfb25Ub3VjaFN0YXJ0Q2FsbGJhY2soZXZlbnQpIHtcclxuXHJcbiAgICB9LFxyXG4gICAgX29uVG91Y2hNb3ZlQ2FsbGJhY2soZXZlbnQpIHtcclxuXHJcbiAgICB9LFxyXG4gICAgX29uVG91Y2hDYW5jZWxDYWxsYmFjayhldmVudCkge1xyXG5cclxuICAgIH0sXHJcbiAgICBfb25Ub3VjaEVuZENhbGxiYWNrKGV2ZW50KSB7XHJcbiAgICAgICAgdmFyIHBvcyA9IGV2ZW50LnRvdWNoLmdldExvY2F0aW9uKCk7XHJcbiAgICAgICAgLy/op6bmkbjngrnlsY/luZXlnZDmoIdcclxuICAgICAgICBjYy5sb2coJ3BvcycscG9zLngscG9zLnkpXHJcbiAgICAgICAgLy8gbGV0IHdvcmxkUG9zMiA9IHRoaXMubm9kZS5jb252ZXJ0VG9Xb3JsZFNwYWNlQVIocG9zKTtcclxuICAgICAgICAvLyAvL+W+l+WIsOeahOe7k+aenOaYr+inpuaRuOeCueeahOS4lueVjOWdkOagh1xyXG4gICAgICAgIC8vIGNjLmxvZygnd29ybGRQb3MyJyx3b3JsZFBvczIueCx3b3JsZFBvczIueSlcclxuICAgICAgICAvL+WboOS4umJn5piv5ZyoY2FudmFz5LiK55qE77yM6ICMY2FudmFz6LCD5pW05oiQ5bGP5bmV5aSn5bCP5piv5pyJ5aSn5bCP55qE77yM5LuW55qE5Z+65YeG54K55bCx5piv5bGP5bmV5aSn5bCP55qE5Lit5b+D44CCXHJcbiAgICAgICAgLy/ogIzlsY/luZXlnZDmoIfnmoTln7rlh4bngrnmmK/lsY/luZXnmoTlt6bkuIvop5LlvIDlp4vnmoTvvIzmiYDku6XopoHlh4/ljrvov5nkuKrlt67lgLxcclxuXHJcblxyXG4gICAgICAgIHZhciBjYW1lcmFQb3M9dGhpcy5tYWluQ2FtZXJhTm9kZS5wb3NpdGlvbjsvL+i/meS4quaYr+ebuOacuueahOWdkOagh1xyXG4gICAgICAgIGNjLmxvZygnY2FtZXJhUG9zJyxjYW1lcmFQb3MueCxjYW1lcmFQb3MueSlcclxuICAgICAgICB2YXIgdGVtcCA9IHBvcy5hZGQoY2FtZXJhUG9zKTsvL+inpuaRuOeCueeahOS4lueVjOWdkOagh1xyXG4gICAgICAgIGNjLmxvZygndGVtcCcsdGVtcC54LHRlbXAueSk7XHJcbiAgICAgICAgLy/op6bmkbjngrnnmoTkuJbnlYzlnZDmoIflh4/ljrvnjrDlnKhwbGF5ZXLnmoTkuJbnlYzlnZDmoIdcclxuICAgICAgICB2YXIgZGlzUG9zPXRlbXAuc3ViKHRoaXMucGxheWVyLnBvc2l0aW9uKVxyXG4gICAgICAgIHZhciBkaXMgPSBNYXRoLmFicyhkaXNQb3MubWFnKCkpICAvLyDkuKTkuKrngrnkuYvpl7TnmoTot53nprssXHJcbiAgICAgICAgdmFyIHYgPSAzMDA7ICAgICAgICAgICAgICAgICAgICAvLyDnp7vliqjpgJ/luqZcclxuICAgICAgICB2YXIgc3BlZWQ9ZGlzIC8gdlxyXG5cclxuICAgICAgICBjYy5Ud2Vlbi5zdG9wQWxsQnlUYXJnZXQodGhpcy5wbGF5ZXIpOy8vIOmYsuatouS5sei3kVxyXG4gICAgICAgIGNjLnR3ZWVuKHRoaXMucGxheWVyKVxyXG4gICAgICAgICAgICAuY2FsbCgoKSA9PiB7XHJcbiAgICAgICAgICAgICAgICBjb25zb2xlLmxvZyhcIuenu+WKqOWJjeeahOWHhuWkh1wiKVxyXG4gICAgICAgICAgICB9KVxyXG4gICAgICAgICAgICAudG8oKHNwZWVkKSwgeyBwb3NpdGlvbjogdGVtcCB9KVxyXG4gICAgICAgICAgICAuY2FsbCgoKSA9PiB7XHJcbiAgICAgICAgICAgICAgICBjb25zb2xlLmxvZyhcIuenu+WKqOWujOaIkO+8gVwiKVxyXG4gICAgICAgICAgICB9KVxyXG4gICAgICAgICAgICAuc3RhcnQoKVxyXG4gICAgfSxcclxuICAgIHVwZGF0ZSAoZHQpIHtcclxuICAgICAgICAvL+eOqeWutuWdkOaghy3nm7jmnLrniLboioLngrljYW52YXPnmoTlnZDmoIfvvIzlvpfliLDnm7jmnLrkuK3lv4PngrnnmoTnm7jlr7nlnZDmoIdcclxuICAgICAgICBsZXQgY2FtZXJhUG9zPXRoaXMucGxheWVyLnBvc2l0aW9uLnN1Yih0aGlzLmNhbWVyYVBhcmVudFBvcylcclxuICAgICAgICAvL+S4jei2heWime+8jFxyXG4gICAgICAgIHRoaXMubWFpbkNhbWVyYU5vZGUuc2V0UG9zaXRpb24oY2FtZXJhUG9zKVxyXG4gICAgfSxcclxufSk7XHJcblxyXG5cclxuIl19